/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.gui;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uifilters.VanillaUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.util.AdventureUtils;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.button.RBA_AmountOutput;
import net.Indyuce.mmoitems.gui.edition.recipe.button.RecipeButtonAction;
import net.Indyuce.mmoitems.gui.edition.recipe.interpreter.RMG_RecipeInterpreter;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RecipeRegistry;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeEditorGUI
extends EditionInventory {
    @NotNull
    final ItemStack nextButtonPage = ItemFactory.of((Material)Material.SPECTRAL_ARROW).name("\u00a7eMore Options \u00a7c\u00bb").build();
    @NotNull
    final ItemStack prevButtonPage = ItemFactory.of((Material)Material.SPECTRAL_ARROW).name("\u00a7c\u00ab \u00a7eMore Options").build();
    @NotNull
    public final ItemStack noButton = ItemFactory.of((Material)Material.IRON_BARS).name("\u00a78---").build();
    @NotNull
    public final ItemStack emptySlot = ItemFactory.of((Material)Material.BARRIER).name("\u00a77No Item").build();
    @NotNull
    public final ItemStack airSlot = ItemFactory.of((Material)Material.STRUCTURE_VOID).name("\u00a77No Item").build();
    @NotNull
    final ConfigurationSection craftingSection;
    @NotNull
    final ConfigurationSection typeSection;
    @NotNull
    final ConfigurationSection nameSection;
    @NotNull
    final RecipeRegistry recipeRegistry;
    @NotNull
    final RBA_AmountOutput amountButton;
    @NotNull
    final String recipeName;
    int buttonsPage;
    @NotNull
    final HashMap<Integer, RecipeButtonAction> buttonsMap = new HashMap();
    @NotNull
    final ArrayList<RecipeButtonAction> buttons = new ArrayList();
    @NotNull
    public final String[] recipeLog = new String[]{FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Write in the chat the item you want, follow any format:", (String[])new String[0]), FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Vanilla: $e[MATERIAL] [AMOUNT] $bex $eDIAMOND 2..", (String[])new String[0]), FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"MMOItem: $e[TYPE].[ID] [AMOUNT] $bex $eSWORD.CUTLASS 1..", (String[])new String[0]), FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Other: $e[KEY] [ARG] [DAT] [AMOUNT]$b (check wiki)", (String[])new String[0]), FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"\u00a78Amount is in the range format, $e[min]..[max]\u00a78, assumed to be $r1..\u00a78 if unspecified.", (String[])new String[0])};
    @NotNull
    static final HashMap<UUID, Boolean> showingInput = new HashMap();
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int PRIMARY = 2;
    public static final int SECONDARY = 3;
    public static final String INPUT_INGREDIENTS = "input";
    public static final String OUTPUT_INGREDIENTS = "output";
    public static final ProvidedUIFilter AIR = new ProvidedUIFilter((UIFilter)new VanillaUIFilter(), "AIR", "0");

    public RecipeEditorGUI(@NotNull Player player, @NotNull MMOItemTemplate template, @NotNull String recipeName, @NotNull RecipeRegistry recipeRegistry) {
        super(player, template);
        this.recipeName = recipeName;
        this.recipeRegistry = recipeRegistry;
        this.moveInput();
        this.craftingSection = RecipeEditorGUI.getSection(this.getEditedSection(), "crafting");
        this.typeSection = RecipeEditorGUI.getSection(this.craftingSection, this.getRecipeRegistry().getRecipeConfigPath());
        this.nameSection = RecipeEditorGUI.getSection(this.typeSection, recipeName);
        this.amountButton = new RBA_AmountOutput(this, this.getCachedItem().clone());
        this.addButton(this.amountButton);
    }

    @Override
    public String getName() {
        return "Edit " + this.getRecipeRegistry().getRecipeTypeName() + " Recipe";
    }

    @NotNull
    public ConfigurationSection getCraftingSection() {
        return this.craftingSection;
    }

    @NotNull
    public ConfigurationSection getTypeSection() {
        return this.typeSection;
    }

    @NotNull
    public ConfigurationSection getNameSection() {
        return this.nameSection;
    }

    @NotNull
    public RecipeRegistry getRecipeRegistry() {
        return this.recipeRegistry;
    }

    @NotNull
    public RBA_AmountOutput getAmountButton() {
        return this.amountButton;
    }

    @NotNull
    public String getRecipeName() {
        return this.recipeName;
    }

    public void putButtons() {
        if (this.getButtonsRow() < 0) {
            return;
        }
        this.buttonsMap.clear();
        if (this.buttonsPage > 0) {
            this.inventory.setItem(this.getButtonsRow() * 9 + 8, this.prevButtonPage);
        }
        if (this.buttonsMap.size() >= (this.buttonsPage + 1) * 7) {
            this.inventory.setItem(this.getButtonsRow() * 9, this.nextButtonPage);
        }
        for (int p = 7 * this.buttonsPage; p < 7 * (this.buttonsPage + 1); ++p) {
            int absolute = this.buttonRowPageClamp(p);
            if (p >= this.buttons.size()) {
                this.inventory.setItem(absolute, this.noButton);
                continue;
            }
            RecipeButtonAction rmg = this.buttons.get(p);
            this.inventory.setItem(absolute, rmg.getButton());
            this.buttonsMap.put(absolute, rmg);
        }
    }

    public int buttonRowPageClamp(int p) {
        int red = SilentNumbers.floor((double)((double)p / 7.0));
        int rowAdditive = this.getButtonsRow() * 9;
        int columnAdditive = (p -= red * 7) + 1;
        return rowAdditive + columnAdditive;
    }

    public abstract int getButtonsRow();

    abstract int getInputSlot(int var1);

    @Override
    public void arrangeInventory() {
        this.putButtons();
        this.putRecipe();
    }

    public abstract void putRecipe();

    @NotNull
    public ItemStack getDisplay(boolean input, int slot) {
        ProvidedUIFilter poof;
        ProvidedUIFilter providedUIFilter = poof = input ? this.getInterpreter().getInput(slot) : this.getInterpreter().getOutput(slot);
        if (poof == null || poof.isAir()) {
            return this.isShowingInput() ? this.emptySlot : this.airSlot;
        }
        return poof.getDisplayStack(null);
    }

    public void addButton(@NotNull RecipeButtonAction rba) {
        this.buttons.add(rba);
    }

    @NotNull
    public abstract RMG_RecipeInterpreter getInterpreter();

    @Override
    public void whenClicked(InventoryClickEvent event) {
        if (VersionUtils.getView((InventoryEvent)event).getTopInventory() != event.getClickedInventory()) {
            return;
        }
        event.setCancelled(true);
        int ingredient = this.getInputSlot(event.getRawSlot());
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            if (ingredient >= 0) {
                if (this.isShowingInput()) {
                    new StatEdition(this, ItemStats.CRAFTING, 0, this.getInterpreter(), ingredient).enable(this.recipeLog);
                } else {
                    new StatEdition(this, ItemStats.CRAFTING, 1, this.getInterpreter(), ingredient).enable(this.recipeLog);
                }
            } else {
                RecipeButtonAction rmg = this.buttonsMap.get(event.getRawSlot());
                if (rmg != null) {
                    rmg.runPrimary();
                }
            }
        } else if (event.getAction() == InventoryAction.PICKUP_HALF) {
            if (ingredient >= 0) {
                if (this.isShowingInput()) {
                    this.getInterpreter().deleteInput(ingredient);
                } else {
                    this.getInterpreter().deleteOutput(this.getInputSlot(event.getRawSlot()));
                }
                this.registerTemplateEdition();
                this.refreshInventory();
            } else {
                RecipeButtonAction rmg = this.buttonsMap.get(event.getRawSlot());
                if (rmg != null) {
                    rmg.runSecondary();
                }
            }
        }
    }

    public static void switchInputFor(@NotNull UUID whom) {
        showingInput.put(whom, !RecipeEditorGUI.isShowingInputFor(whom));
    }

    public static boolean isShowingInputFor(@NotNull UUID whom) {
        return showingInput.getOrDefault(whom, true);
    }

    public boolean isShowingInput() {
        return RecipeEditorGUI.isShowingInputFor(this.getPlayer().getUniqueId());
    }

    public void switchInput() {
        RecipeEditorGUI.switchInputFor(this.getPlayer().getUniqueId());
    }

    @NotNull
    public static ItemStack rename(@NotNull ItemStack itm, @NotNull String name) {
        ItemMeta iMeta = itm.getItemMeta();
        iMeta.setDisplayName(MythicLib.plugin.parseColors(name));
        itm.setItemMeta(iMeta);
        return itm;
    }

    @NotNull
    public static ItemStack addLore(@NotNull ItemStack itm, @NotNull ArrayList<String> lines) {
        if (!itm.hasItemMeta()) {
            return itm;
        }
        ItemMeta iMeta = itm.getItemMeta();
        if (iMeta == null) {
            return itm;
        }
        ArrayList<String> currentLore = iMeta.getLore();
        if (currentLore == null) {
            currentLore = new ArrayList<String>();
        }
        currentLore.addAll(lines);
        AdventureUtils.setLore((ItemMeta)iMeta, currentLore);
        itm.setItemMeta(iMeta);
        return itm;
    }

    @NotNull
    public static ConfigurationSection getSection(@NotNull ConfigurationSection root, @NotNull String path) {
        ConfigurationSection section = root.getConfigurationSection(path);
        if (section == null) {
            section = root.createSection(path);
        }
        return section;
    }

    public void moveInput() {
        ConfigurationSection crafting = RecipeEditorGUI.getSection(this.getEditedSection(), "crafting");
        ConfigurationSection shaped = RecipeEditorGUI.getSection(crafting, this.getRecipeRegistry().getRecipeConfigPath());
        RecipeEditorGUI.moveInput(shaped, this.recipeName);
    }

    public static void tripleDebug(@NotNull ConfigurationSection section) {
        MMOItems.print(null, "\u00a7d-\u00a77 Section \u00a75" + section.getCurrentPath(), null, new String[0]);
        for (String key : section.getKeys(false)) {
            MMOItems.print(null, "\u00a7d +\u00a77 " + key, null, new String[0]);
            MMOItems.print(null, "\u00a7d-\u00a7e-\u00a77 As List \u00a75" + section.getCurrentPath() + "." + key + "\u00a77 {\u00a7d" + section.getStringList(key).size() + "\u00a77}", null, new String[0]);
            for (String listKey : section.getStringList(key)) {
                MMOItems.print(null, "\u00a7d +\u00a7e-\u00a77" + listKey, null, new String[0]);
            }
            ConfigurationSection asSection = RecipeEditorGUI.getSection(section, key);
            MMOItems.print(null, "\u00a78--\u00a7d-\u00a77 Section \u00a75" + asSection.getCurrentPath(), null, new String[0]);
            for (String asKey : asSection.getKeys(false)) {
                MMOItems.print(null, "\u00a78--\u00a7d +\u00a77 " + asKey, null, new String[0]);
                MMOItems.print(null, "\u00a78--\u00a7d-\u00a7e-\u00a77 As List \u00a75" + asSection.getCurrentPath() + "." + asKey + "\u00a77 {\u00a7d" + asSection.getStringList(asKey).size() + "\u00a77}", null, new String[0]);
                for (String listKey : asSection.getStringList(asKey)) {
                    MMOItems.print(null, "\u00a78--\u00a7d +\u00a7e-\u00a77" + listKey, null, new String[0]);
                }
                ConfigurationSection asESection = RecipeEditorGUI.getSection(asSection, asKey);
                MMOItems.print(null, "\u00a70--\u00a78--\u00a7d-\u00a77 Section \u00a75" + asESection.getCurrentPath(), null, new String[0]);
                for (String asEKey : asESection.getKeys(false)) {
                    MMOItems.print(null, "\u00a70--\u00a78--\u00a7d +\u00a77 " + asEKey, null, new String[0]);
                    MMOItems.print(null, "\u00a70--\u00a78--\u00a7d-\u00a7e-\u00a77 As List \u00a75" + asESection.getCurrentPath() + "." + asEKey + "\u00a77 {\u00a7d" + asESection.getStringList(asEKey).size() + "\u00a77}", null, new String[0]);
                    for (String listKey : asESection.getStringList(asEKey)) {
                        MMOItems.print(null, "\u00a70--\u00a78--\u00a7d +\u00a7e-\u00a77" + listKey, null, new String[0]);
                    }
                }
            }
        }
    }

    public static ConfigurationSection moveInput(@NotNull ConfigurationSection recipeSection, @NotNull String nameOfRecipe) {
        ConfigurationSection name;
        if (recipeSection.isConfigurationSection(nameOfRecipe)) {
            name = RecipeEditorGUI.getSection(recipeSection, nameOfRecipe);
            String item_yml = name.getString("input1");
            String ingot_yml = name.getString("input2");
            if (item_yml != null && ingot_yml != null) {
                name.set("input1", null);
                name.set("input2", null);
                name.set(INPUT_INGREDIENTS, (Object)(RecipeEditorGUI.poofFromLegacy(item_yml) + "|" + RecipeEditorGUI.poofFromLegacy(ingot_yml)));
                name.set(OUTPUT_INGREDIENTS, (Object)"v AIR 0|v AIR 0");
            }
        } else {
            List sc = recipeSection.getStringList(nameOfRecipe);
            recipeSection.set(nameOfRecipe, null);
            name = RecipeEditorGUI.getSection(recipeSection, nameOfRecipe);
            name.set(INPUT_INGREDIENTS, (Object)sc);
        }
        return name;
    }

    @NotNull
    public static String poofFromLegacy(@Nullable String legacy) {
        if (legacy == null || "[]".equals(legacy)) {
            return "v AIR - 1..";
        }
        if (legacy.contains(" ")) {
            return legacy;
        }
        int aLoc = legacy.indexOf(58);
        QuickNumberRange amount = new QuickNumberRange(Double.valueOf(1.0), null);
        if (aLoc > 0) {
            String am = legacy.substring(aLoc + 1);
            legacy = legacy.substring(0, aLoc);
            Integer du = SilentNumbers.IntegerParse((String)am);
            if (du == null) {
                du = 1;
            }
            amount = new QuickNumberRange(Double.valueOf(du.intValue()), null);
        }
        if (legacy.contains(".")) {
            String[] mmo = legacy.split("\\.");
            return "m " + mmo[0] + " " + mmo[1] + " " + amount;
        }
        return "v " + legacy + " - " + amount;
    }

    @NotNull
    public static ProvidedUIFilter readIngredientFrom(@NotNull String str, @NotNull FriendlyFeedbackProvider ffp) throws IllegalArgumentException {
        String[] split;
        Material asMaterial = null;
        try {
            asMaterial = Material.valueOf((String)str.toUpperCase().replace(" ", "_").replace("-", "_"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (asMaterial != null) {
            if (asMaterial.isAir()) {
                ProvidedUIFilter result = new ProvidedUIFilter((UIFilter)VanillaUIFilter.get(), "AIR", "0");
                result.setAmountRange(new QuickNumberRange(null, null));
                return result;
            }
            if (!asMaterial.isItem()) {
                throw new IllegalArgumentException("Invalid Ingredient $u" + str + "$b ($fNot an Item$b).");
            }
            ProvidedUIFilter poof = UIFilterManager.getUIFilter((String)"v", (String)asMaterial.toString(), (String)"", (String)"1..", (FriendlyFeedbackProvider)ffp);
            if (poof != null) {
                return poof;
            }
            ffp.sendTo(FriendlyFeedbackCategory.ERROR, MMOItems.getConsole());
            ffp.sendTo(FriendlyFeedbackCategory.FAILURE, MMOItems.getConsole());
            throw new IllegalArgumentException("Invalid Ingredient $u" + str);
        }
        if (str.contains(".") && !str.contains(" ") && (split = str.split("\\.")).length == 2) {
            String iType = split[0];
            String iID = split[1];
            ProvidedUIFilter poof = UIFilterManager.getUIFilter((String)"m", (String)iType, (String)iID, (String)"1..", (FriendlyFeedbackProvider)ffp);
            if (poof != null) {
                return poof;
            }
            ffp.sendAllTo(MMOItems.getConsole());
            throw new IllegalArgumentException("Invalid Ingredient $u" + str);
        }
        ProvidedUIFilter poof = UIFilterManager.getUIFilter((String)str, (FriendlyFeedbackProvider)ffp);
        if (poof != null) {
            return poof;
        }
        ffp.sendAllTo(MMOItems.getConsole());
        throw new IllegalArgumentException("Invalid Ingredient $u" + str);
    }
}

