/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.button.type;

import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.recipe.button.RecipeButtonAction;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RBA_DoubleButton
extends RecipeButtonAction {
    @NotNull
    public final String[] amountLog = new String[]{FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Write in the chat a number, ex $e2.5$b.", (String[])new String[0])};
    @NotNull
    public final String[] integerLog = new String[]{FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Write in the chat an integer number, ex $e8$b.", (String[])new String[0])};

    public RBA_DoubleButton(@NotNull RecipeEditorGUI inv) {
        super(inv);
    }

    public double getValue() {
        return this.getInv().getNameSection().getDouble(this.getDoubleConfigPath(), this.getDefaultValue());
    }

    @NotNull
    public abstract String getDoubleConfigPath();

    @Override
    public boolean runPrimary() {
        new StatEdition(this.getInv(), ItemStats.CRAFTING, 2, this).enable(this.requireInteger() ? this.integerLog : this.amountLog);
        return true;
    }

    @Override
    public void primaryProcessInput(@NotNull String message, Object ... info) throws IllegalArgumentException {
        Double number;
        if (this.requireInteger()) {
            Integer asInteger = SilentNumbers.IntegerParse((String)message);
            if (asInteger == null) {
                throw new IllegalArgumentException("Expected integer number instead of $u" + message);
            }
            number = (double)asInteger;
        } else {
            number = SilentNumbers.DoubleParse((String)message);
            if (number == null) {
                throw new IllegalArgumentException("Expected a number instead of $u" + message);
            }
        }
        if (this.getRange() != null && !this.getRange().inRange(number.doubleValue())) {
            throw new IllegalArgumentException("Number $r" + number + "$b is out of range. Expected " + this.getRange().toStringColored());
        }
        this.getInv().getNameSection().set(this.getDoubleConfigPath(), (Object)number);
    }

    @Nullable
    public abstract QuickNumberRange getRange();

    public abstract boolean requireInteger();

    @Override
    public boolean runSecondary() {
        this.getInv().getNameSection().set(this.getDoubleConfigPath(), null);
        this.clickSFX();
        this.getInv().registerTemplateEdition();
        return true;
    }

    @Override
    public void secondaryProcessInput(@NotNull String message, Object ... info) throws IllegalArgumentException {
    }

    public abstract double getDefaultValue();

    @NotNull
    public abstract ItemStack getDoubleButton();

    @Override
    @NotNull
    public ItemStack getButton() {
        return RecipeEditorGUI.addLore(this.getDoubleButton().clone(), SilentNumbers.toArrayList((Object[])new String[]{"", "\u00a77Current Value: " + this.getValue(), "", ChatColor.YELLOW + "\u25ba" + " Right click to reset \u00a78(to\u00a74 " + this.getDefaultValue() + "\u00a78)\u00a7e.", ChatColor.YELLOW + "\u25ba" + " Left click to toggle this option."}));
    }
}

