/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe;

import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.HashMap;
import java.util.Set;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.RecipeListGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RMGRR_LegacyBurning;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RMGRR_MegaShaped;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RMGRR_Shaped;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RMGRR_Shapeless;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RMGRR_Smithing;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RMGRR_SuperShaped;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RecipeRegistry;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.burninglegacy.CraftingType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RecipeTypeListGUI
extends EditionInventory {
    @NotNull
    private static final ItemStack NEXT_PAGE = ItemFactory.of((Material)Material.ARROW).name(FFPMMOItems.get().getExampleFormat() + "Next Page").build();
    @NotNull
    private static final ItemStack PREVIOUS_PAGE = ItemFactory.of((Material)Material.ARROW).name(FFPMMOItems.get().getExampleFormat() + "Previous Page").build();
    @NotNull
    private static final ItemStack NO_RECIPE = ItemFactory.of((Material)Material.LIGHT_GRAY_STAINED_GLASS_PANE).name("").build();
    @NotNull
    final HashMap<Integer, RecipeRegistry> recipeTypeMap = new HashMap();
    @NotNull
    static final HashMap<String, RecipeRegistry> registeredRecipes = new HashMap();

    public RecipeTypeListGUI(@NotNull Player player, @NotNull MMOItemTemplate template) {
        super(player, template);
        this.page = 0;
    }

    @Override
    public String getName() {
        return "Choose Recipe Type";
    }

    @Override
    public void arrangeInventory() {
        this.recipeTypeMap.clear();
        if (this.page > 0) {
            this.inventory.setItem(27, PREVIOUS_PAGE);
        }
        if (registeredRecipes.size() >= (this.page + 1) * 21) {
            this.inventory.setItem(36, NEXT_PAGE);
        }
        HashMap<Integer, RecipeRegistry> reg = new HashMap<Integer, RecipeRegistry>();
        int op = 0;
        for (RecipeRegistry r : registeredRecipes.values()) {
            reg.put(op, r);
            ++op;
        }
        for (int p = 21 * this.page; p < 21 * (this.page + 1); ++p) {
            int absolute = RecipeTypeListGUI.page(p);
            if (p >= registeredRecipes.size()) {
                this.inventory.setItem(absolute, NO_RECIPE);
                continue;
            }
            RecipeRegistry rr = (RecipeRegistry)reg.get(p);
            this.inventory.setItem(absolute, rr.getDisplayListItem());
            this.recipeTypeMap.put(absolute, rr);
        }
    }

    public static int page(int p) {
        int red = SilentNumbers.floor((double)((double)p / 21.0));
        int relRow = SilentNumbers.floor((double)((double)(p -= red * 21) / 7.0));
        int relCol = p - 7 * relRow;
        int rowAdditive = 18 + relRow * 9;
        int columnAdditive = relCol + 1;
        return rowAdditive + columnAdditive;
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        if (VersionUtils.getView((InventoryEvent)event).getTopInventory() != event.getClickedInventory()) {
            return;
        }
        event.setCancelled(true);
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            RecipeRegistry recipeType;
            if (event.getSlot() == 27) {
                --this.page;
                this.refreshInventory();
            } else if (event.getSlot() == 36) {
                ++this.page;
                this.refreshInventory();
            } else if (event.getSlot() > 18 && (recipeType = this.recipeTypeMap.get(event.getSlot())) != null) {
                new RecipeListGUI(this.player, this.template, recipeType).open(this);
            }
        }
    }

    public static void registerNativeRecipes() {
        RecipeTypeListGUI.registerRecipe(new RMGRR_Smithing());
        RecipeTypeListGUI.registerRecipe(new RMGRR_Shapeless());
        RecipeTypeListGUI.registerRecipe(new RMGRR_Shaped());
        RecipeTypeListGUI.registerRecipe(new RMGRR_SuperShaped());
        RecipeTypeListGUI.registerRecipe(new RMGRR_MegaShaped());
        RecipeTypeListGUI.registerRecipe(new RMGRR_LegacyBurning(CraftingType.FURNACE));
        RecipeTypeListGUI.registerRecipe(new RMGRR_LegacyBurning(CraftingType.BLAST));
        RecipeTypeListGUI.registerRecipe(new RMGRR_LegacyBurning(CraftingType.SMOKER));
        RecipeTypeListGUI.registerRecipe(new RMGRR_LegacyBurning(CraftingType.CAMPFIRE));
    }

    public static void registerRecipe(@NotNull RecipeRegistry recipe) {
        registeredRecipes.put(recipe.getRecipeConfigPath(), recipe);
    }

    @NotNull
    public static Set<String> getRegisteredRecipes() {
        return registeredRecipes.keySet();
    }

    @NotNull
    public static RecipeRegistry getRegisteredRecipe(@NotNull String name) {
        return registeredRecipes.get(name);
    }
}

