/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.api.util.ItemFactory;
import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class UpgradingEdition
extends EditionInventory {
    private static final ItemStack notAvailable = ItemFactory.of((Material)Material.RED_STAINED_GLASS_PANE).name("&cNot Available").build();

    public UpgradingEdition(Player player, MMOItemTemplate template) {
        super(player, template);
    }

    @Override
    public String getName() {
        return "Upgrade Setup: " + this.template.getId();
    }

    @Override
    public void arrangeInventory() {
        boolean workbench = this.getEditedSection().getBoolean("upgrade.workbench");
        if (!this.template.getType().corresponds(Type.CONSUMABLE)) {
            ItemStack workbenchItem = new ItemStack(Material.CRAFTING_TABLE);
            ItemMeta workbenchItemMeta = workbenchItem.getItemMeta();
            workbenchItemMeta.setDisplayName(ChatColor.GREEN + "Workbench Upgrade Only?");
            ArrayList<String> workbenchItemLore = new ArrayList<String>();
            workbenchItemLore.add(ChatColor.GRAY + "When toggled on, players must");
            workbenchItemLore.add(ChatColor.GRAY + "use a crafting station recipe in");
            workbenchItemLore.add(ChatColor.GRAY + "order to upgrade their weapon.");
            workbenchItemLore.add("");
            workbenchItemLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GOLD + workbench);
            workbenchItemLore.add("");
            workbenchItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
            workbenchItemMeta.setLore(workbenchItemLore);
            workbenchItem.setItemMeta(workbenchItemMeta);
            this.inventory.setItem(20, workbenchItem);
            String upgradeTemplate = this.getEditedSection().getString("upgrade.template");
            ItemStack templateItem = new ItemStack(Material.OAK_SIGN);
            ItemMeta templateItemMeta = templateItem.getItemMeta();
            templateItemMeta.setDisplayName(ChatColor.GREEN + "Upgrade Template");
            ArrayList<String> templateItemLore = new ArrayList<String>();
            templateItemLore.add(ChatColor.GRAY + "This option dictates what stats are improved");
            templateItemLore.add(ChatColor.GRAY + "when your item is upgraded. More info on the wiki.");
            templateItemLore.add("");
            templateItemLore.add(ChatColor.GRAY + "Current Value: " + (upgradeTemplate == null ? ChatColor.RED + "No template" : ChatColor.GOLD + upgradeTemplate));
            templateItemLore.add("");
            templateItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to input the template.");
            templateItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
            templateItemMeta.setLore(templateItemLore);
            templateItem.setItemMeta(templateItemMeta);
            this.inventory.setItem(22, templateItem);
            int max = this.getEditedSection().getInt("upgrade.max");
            ItemStack maxItem = new ItemStack(Material.BARRIER);
            ItemMeta maxItemMeta = maxItem.getItemMeta();
            maxItemMeta.setDisplayName(ChatColor.GREEN + "Max Upgrades");
            ArrayList<String> maxItemLore = new ArrayList<String>();
            maxItemLore.add(ChatColor.GRAY + "The maximum amount of upgrades your");
            maxItemLore.add(ChatColor.GRAY + "item may receive (recipe or consumable).");
            maxItemLore.add("");
            maxItemLore.add(ChatColor.GRAY + "Current Value: " + (max == 0 ? ChatColor.RED + "No limit" : ChatColor.GOLD + "" + max));
            maxItemLore.add("");
            maxItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to chance this value.");
            maxItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
            maxItemMeta.setLore(maxItemLore);
            maxItem.setItemMeta(maxItemMeta);
            this.inventory.setItem(40, maxItem);
            int min = this.getEditedSection().getInt("upgrade.min", 0);
            ItemStack minItem = new ItemStack(Material.BARRIER);
            ItemMeta minItemMeta = minItem.getItemMeta();
            minItemMeta.setDisplayName(ChatColor.GREEN + "Min Upgrades");
            ArrayList<String> minItemLore = new ArrayList<String>();
            minItemLore.add(ChatColor.GRAY + "The minimum level your item can be");
            minItemLore.add(ChatColor.GRAY + "downgraded to (by dying or breaking).");
            minItemLore.add("");
            minItemLore.add(ChatColor.GRAY + "Current Value: " + (min == 0 ? ChatColor.RED + "0" : ChatColor.GOLD + String.valueOf(min)));
            minItemLore.add("");
            minItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to chance this value.");
            minItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
            minItemMeta.setLore(minItemLore);
            minItem.setItemMeta(minItemMeta);
            this.inventory.setItem(41, minItem);
        } else {
            this.inventory.setItem(20, notAvailable);
            this.inventory.setItem(22, notAvailable);
        }
        if (!workbench || this.template.getType().corresponds(Type.CONSUMABLE)) {
            String reference = this.getEditedSection().getString("upgrade.reference");
            ItemStack referenceItem = new ItemStack(Material.PAPER);
            ItemMeta referenceItemMeta = referenceItem.getItemMeta();
            referenceItemMeta.setDisplayName(ChatColor.GREEN + "Upgrade Reference");
            ArrayList<String> referenceItemLore = new ArrayList<String>();
            referenceItemLore.add(ChatColor.GRAY + "This option dictates what consumables can");
            referenceItemLore.add(ChatColor.GRAY + "upgrade your item. " + ChatColor.AQUA + "The upgrade reference");
            referenceItemLore.add(ChatColor.AQUA + "of your consumable must match the reference");
            referenceItemLore.add(ChatColor.AQUA + "of the target item" + ChatColor.GRAY + ", otherwise it can't upgrade it.");
            referenceItemLore.add("");
            referenceItemLore.add(ChatColor.GRAY + "Current Value: " + (reference == null ? ChatColor.RED + "No reference" : ChatColor.GOLD + reference));
            referenceItemLore.add("");
            referenceItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to input the reference.");
            referenceItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
            referenceItemMeta.setLore(referenceItemLore);
            referenceItem.setItemMeta(referenceItemMeta);
            this.inventory.setItem(38, referenceItem);
        } else {
            this.inventory.setItem(38, notAvailable);
        }
        double success = this.getEditedSection().getDouble("upgrade.success");
        ItemStack successItem = new ItemStack(Material.EXPERIENCE_BOTTLE);
        ItemMeta successItemMeta = successItem.getItemMeta();
        successItemMeta.setDisplayName(ChatColor.GREEN + "Success Chance");
        ArrayList<String> successItemLore = new ArrayList<String>();
        successItemLore.add(ChatColor.GRAY + "The chance of successfully upgrading");
        successItemLore.add(ChatColor.GRAY + "when using a consumable or when using");
        successItemLore.add(ChatColor.GRAY + "a station upgrading recipe.");
        successItemLore.add("");
        successItemLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GOLD + (success == 0.0 ? "100" : "" + success) + "%");
        successItemLore.add("");
        successItemLore.add(ChatColor.YELLOW + "\u25ba" + " Left click to change this value.");
        successItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
        successItemMeta.setLore(successItemLore);
        successItem.setItemMeta(successItemMeta);
        this.inventory.setItem(24, successItem);
        if (success > 0.0 && !this.template.getType().corresponds(Type.CONSUMABLE)) {
            ItemStack destroyOnFail = new ItemStack(Material.FISHING_ROD);
            ItemMeta destroyOnFailMeta = destroyOnFail.getItemMeta();
            ((Damageable)destroyOnFailMeta).setDamage(30);
            destroyOnFailMeta.setDisplayName(ChatColor.GREEN + "Destroy on fail?");
            ArrayList<String> destroyOnFailLore = new ArrayList<String>();
            destroyOnFailLore.add(ChatColor.GRAY + "When toggled on, the item will be");
            destroyOnFailLore.add(ChatColor.GRAY + "destroyed when failing at upgrading it.");
            destroyOnFailLore.add("");
            destroyOnFailLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GOLD + this.getEditedSection().getBoolean("upgrade.destroy"));
            destroyOnFailLore.add("");
            destroyOnFailLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
            destroyOnFailMeta.setLore(destroyOnFailLore);
            destroyOnFail.setItemMeta(destroyOnFailMeta);
            this.inventory.setItem(42, destroyOnFail);
        }
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        boolean bool;
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory() || !MMOUtils.isMetaItem(item, false)) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Success Chance")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.UPGRADE, "rate").enable("Write in the chat the success rate you want.");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("upgrade.success")) {
                this.getEditedSection().set("upgrade.success", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset success chance.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Max Upgrades")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.UPGRADE, "max").enable("Write in the chat the number you want.");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("upgrade.max")) {
                this.getEditedSection().set("upgrade.max", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the number of max upgrades.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Min Upgrades")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.UPGRADE, "min").enable("Write in the chat the number you want.");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("upgrade.min")) {
                this.getEditedSection().set("upgrade.min", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the number of min level.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Upgrade Template")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.UPGRADE, "template").enable("Write in the chat the upgrade template ID you want.");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("upgrade.template")) {
                this.getEditedSection().set("upgrade.template", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset upgrade template.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Upgrade Reference")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.UPGRADE, "ref").enable("Write in the chat the upgrade reference (text) you want.");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("upgrade.reference")) {
                this.getEditedSection().set("upgrade.reference", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset upgrade reference.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Workbench Upgrade Only?")) {
            bool = !this.getEditedSection().getBoolean("upgrade.workbench");
            this.getEditedSection().set("upgrade.workbench", (Object)bool);
            this.registerTemplateEdition();
            this.player.sendMessage(MMOItems.plugin.getPrefix() + (bool ? "Your item must now be upgraded via recipes." : "Your item can now be upgraded using consumables."));
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Destroy on fail?")) {
            bool = !this.getEditedSection().getBoolean("upgrade.destroy");
            this.getEditedSection().set("upgrade.destroy", (Object)bool);
            this.registerTemplateEdition();
            this.player.sendMessage(MMOItems.plugin.getPrefix() + (bool ? "Your item will be destroyed upon failing upgrade." : "Your item will not be destroyed upon failing upgrade."));
        }
    }
}

