/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.Arrays;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class RevisionInventory
extends EditionInventory {
    static ItemStack name;
    static ItemStack lore;
    static ItemStack enchantments;
    static ItemStack upgrades;
    static ItemStack gemstones;
    static ItemStack soulbind;
    static ItemStack external;
    static ItemStack revisionID;
    static final String REVISION = "\u00a76Revision ID";

    public RevisionInventory(@NotNull Player player, @NotNull MMOItemTemplate template) {
        super(player, template);
        if (revisionID == null) {
            name = ItemFactory.of((Material)Material.NAME_TAG).name("\u00a73Name").lore((Iterable)SilentNumbers.chop((String)"The display name of the old item will be transferred to the new one", (int)40, (String)"\u00a77")).build();
            lore = ItemFactory.of((Material)Material.WRITABLE_BOOK).name("\u00a7dLore").lore((Iterable)SilentNumbers.chop((String)"Specifically keeps lore lines that begin with the color code \u00a7n&7", (int)40, (String)"\u00a77")).build();
            enchantments = ItemFactory.of((Material)Material.EXPERIENCE_BOTTLE).name("\u00a7bEnchantments").lore((Iterable)SilentNumbers.chop((String)"This keeps specifically enchantments that are not accounted for in upgrades nor gem stones (presumably added by the player).", (int)40, (String)"\u00a77")).build();
            upgrades = ItemFactory.of((Material)Material.NETHER_STAR).name("\u00a7aUpgrades").lore((Iterable)SilentNumbers.chop((String)"Will this item retain the upgrade level after updating? Only the Upgrade Level is kept (as long as it does not exceed the new max).", (int)40, (String)"\u00a77")).build();
            gemstones = ItemFactory.of((Material)Material.EMERALD).name("\u00a7eGem Stones").lore((Iterable)SilentNumbers.chop((String)"Will the item retain its gem stones when updating? (Note that this allows gemstone overflow - will keep ALL old gemstones even if you reduced the gem sockets)", (int)40, (String)"\u00a77")).build();
            soulbind = ItemFactory.of((Material)Material.ENDER_EYE).name("\u00a7cSoulbind").lore((Iterable)SilentNumbers.chop((String)"If the old item is soulbound, updating will transfer the soulbind to the new item.", (int)40, (String)"\u00a77")).build();
            external = ItemFactory.of((Material)Material.SPRUCE_SIGN).name("\u00a79External SH").lore((Iterable)SilentNumbers.chop((String)"Data registered onto the item's StatHistory by external plugins (like GemStones but not removable)", (int)40, (String)"\u00a77")).build();
            revisionID = ItemFactory.of((Material)Material.ITEM_FRAME).name(REVISION).lore((Iterable)SilentNumbers.chop((String)"The updater is always active, increasing this number will update all instances of this MMOItem without further action.", (int)40, (String)"\u00a77")).build();
        }
    }

    @Override
    public String getName() {
        return "Revision Manager";
    }

    @Override
    public void arrangeInventory() {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack which = null;
            Boolean enable = null;
            Integer id = null;
            switch (i) {
                case 19: {
                    which = name.clone();
                    enable = MMOItems.plugin.getLanguage().revisionOptions.shouldKeepName();
                    break;
                }
                case 20: {
                    which = lore.clone();
                    enable = MMOItems.plugin.getLanguage().revisionOptions.shouldKeepLore();
                    break;
                }
                case 21: {
                    which = enchantments.clone();
                    enable = MMOItems.plugin.getLanguage().revisionOptions.shouldKeepEnchantments();
                    break;
                }
                case 22: {
                    which = external.clone();
                    enable = MMOItems.plugin.getLanguage().revisionOptions.shouldKeepExternalSH();
                    break;
                }
                case 28: {
                    which = upgrades.clone();
                    enable = MMOItems.plugin.getLanguage().revisionOptions.shouldKeepUpgrades();
                    break;
                }
                case 29: {
                    which = gemstones.clone();
                    enable = MMOItems.plugin.getLanguage().revisionOptions.shouldKeepGemStones();
                    break;
                }
                case 30: {
                    which = soulbind.clone();
                    enable = MMOItems.plugin.getLanguage().revisionOptions.shouldKeepSoulBind();
                    break;
                }
                case 33: {
                    id = this.getEditedSection().getInt(ItemStats.REVISION_ID.getPath(), 1);
                    which = revisionID.clone();
                    break;
                }
            }
            if (which == null) continue;
            if (enable != null) {
                this.inventory.setItem(i, this.addLore(which, "", "\u00a78Enabled (in config)? \u00a76" + enable.toString()));
                continue;
            }
            if (id != null) {
                this.inventory.setItem(i, this.addLore(which, "", "\u00a78Current Value: \u00a76" + id));
                continue;
            }
            this.inventory.setItem(i, which);
        }
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory() || !MMOUtils.isMetaItem(item, false)) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(REVISION)) {
            int id = this.getEditedSection().getInt(ItemStats.REVISION_ID.getPath(), 1);
            id = event.getAction() == InventoryAction.PICKUP_HALF ? Math.max(id - 1, 1) : Math.min(id + 1, Integer.MAX_VALUE);
            this.getEditedSection().set(ItemStats.REVISION_ID.getPath(), (Object)id);
            this.registerTemplateEdition();
            event.setCurrentItem(this.addLore(revisionID.clone(), "", "\u00a78Current Value: \u00a76" + id));
        }
    }

    @NotNull
    ItemStack addLore(@NotNull ItemStack iSource, String ... extraLines) {
        ArrayList<String> iLore = new ArrayList<String>();
        ItemMeta iMeta = iSource.getItemMeta();
        if (iMeta != null && iMeta.getLore() != null) {
            iLore = new ArrayList(iMeta.getLore());
        }
        iLore.addAll(Arrays.asList(extraLines));
        iMeta.setLore(iLore);
        iSource.setItemMeta(iMeta);
        return iSource;
    }
}

