/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.particle.api.ParticleType;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ParticlesEdition
extends EditionInventory {
    private static final NamespacedKey PATTERN_MODIFIED_KEY = new NamespacedKey((Plugin)MMOItems.plugin, "PatternModifierId");

    public ParticlesEdition(Player player, MMOItemTemplate template) {
        super(player, template);
    }

    @Override
    public String getName() {
        return "Particles: " + this.template.getId();
    }

    @Override
    public void arrangeInventory() {
        int[] slots = new int[]{37, 38, 39, 40, 41, 42, 43};
        int n = 0;
        ParticleType particleType = null;
        try {
            particleType = ParticleType.valueOf(this.getEditedSection().getString("item-particles.type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack particleTypeItem = new ItemStack(Material.PINK_STAINED_GLASS);
        ItemMeta particleTypeItemMeta = particleTypeItem.getItemMeta();
        particleTypeItemMeta.setDisplayName(ChatColor.GREEN + "Particle Pattern");
        ArrayList<String> particleTypeItemLore = new ArrayList<String>();
        particleTypeItemLore.add(ChatColor.GRAY + "The particle pattern defines how");
        particleTypeItemLore.add(ChatColor.GRAY + "particles behave, what pattern they follow");
        particleTypeItemLore.add(ChatColor.GRAY + "when displayed or what shape they form.");
        particleTypeItemLore.add("");
        particleTypeItemLore.add(ChatColor.GRAY + "Current Value: " + (particleType == null ? ChatColor.RED + "No type selected." : ChatColor.GOLD + particleType.getDefaultName()));
        if (particleType != null) {
            particleTypeItemLore.add("" + ChatColor.GRAY + ChatColor.ITALIC + particleType.getDescription());
        }
        particleTypeItemLore.add("");
        particleTypeItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
        particleTypeItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to change this value.");
        particleTypeItemMeta.setLore(particleTypeItemLore);
        particleTypeItem.setItemMeta(particleTypeItemMeta);
        if (particleType != null) {
            ConfigurationSection psection = this.getEditedSection().getConfigurationSection("item-particles");
            for (String modifier : particleType.getModifiers()) {
                ItemStack modifierItem = new ItemStack(Material.GRAY_DYE);
                ItemMeta modifierItemMeta = modifierItem.getItemMeta();
                modifierItemMeta.setDisplayName(ChatColor.GREEN + UtilityMethods.caseOnWords((String)modifier.toLowerCase().replace("-", " ")));
                ArrayList<String> modifierItemLore = new ArrayList<String>();
                modifierItemLore.add("" + ChatColor.GRAY + ChatColor.ITALIC + "This is a pattern modifier.");
                modifierItemLore.add("" + ChatColor.GRAY + ChatColor.ITALIC + "Changing this value will slightly");
                modifierItemLore.add("" + ChatColor.GRAY + ChatColor.ITALIC + "customize the particle pattern.");
                modifierItemLore.add("");
                modifierItemLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GOLD + (psection.contains(modifier) ? psection.getDouble(modifier) : particleType.getModifier(modifier)));
                modifierItemMeta.setLore(modifierItemLore);
                modifierItemMeta.getPersistentDataContainer().set(PATTERN_MODIFIED_KEY, PersistentDataType.STRING, (Object)modifier);
                modifierItem.setItemMeta(modifierItemMeta);
                this.inventory.setItem(slots[n++], modifierItem);
            }
        }
        Particle particle = null;
        try {
            particle = Particle.valueOf((String)this.getEditedSection().getString("item-particles.particle"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack particleItem = new ItemStack(Material.BLAZE_POWDER);
        ItemMeta particleItemMeta = particleItem.getItemMeta();
        particleItemMeta.setDisplayName(ChatColor.GREEN + "Particle");
        ArrayList<String> particleItemLore = new ArrayList<String>();
        particleItemLore.add(ChatColor.GRAY + "Defines what particle is used");
        particleItemLore.add(ChatColor.GRAY + "in the particle effect.");
        particleItemLore.add("");
        particleItemLore.add(ChatColor.GRAY + "Current Value: " + (particle == null ? ChatColor.RED + "No particle selected." : ChatColor.GOLD + UtilityMethods.caseOnWords((String)particle.name().toLowerCase().replace("_", " "))));
        particleItemLore.add("");
        particleItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
        particleItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to change this value.");
        particleItemMeta.setLore(particleItemLore);
        particleItem.setItemMeta(particleItemMeta);
        if (particle != null && MMOUtils.isColorable(particle)) {
            int red = this.getEditedSection().getInt("item-particles.color.red");
            int green = this.getEditedSection().getInt("item-particles.color.green");
            int blue = this.getEditedSection().getInt("item-particles.color.blue");
            ItemStack colorItem = new ItemStack(Material.RED_DYE);
            ItemMeta colorItemMeta = colorItem.getItemMeta();
            colorItemMeta.setDisplayName(ChatColor.GREEN + "Particle Color");
            ArrayList<String> colorItemLore = new ArrayList<String>();
            colorItemLore.add(ChatColor.GRAY + "The RGB color of your particle.");
            colorItemLore.add("");
            colorItemLore.add(ChatColor.GRAY + "Current Value (R-G-B):");
            colorItemLore.add("" + ChatColor.RED + ChatColor.BOLD + red + ChatColor.GRAY + " - " + ChatColor.GREEN + ChatColor.BOLD + green + ChatColor.GRAY + " - " + ChatColor.BLUE + ChatColor.BOLD + blue);
            colorItemLore.add("");
            colorItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
            colorItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to change this value.");
            colorItemMeta.setLore(colorItemLore);
            colorItem.setItemMeta(colorItemMeta);
            this.inventory.setItem(25, colorItem);
        }
        ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        glassMeta.setDisplayName(ChatColor.RED + "- No Modifier -");
        glass.setItemMeta(glassMeta);
        while (n < slots.length) {
            this.inventory.setItem(slots[n++], glass);
        }
        this.inventory.setItem(21, particleTypeItem);
        this.inventory.setItem(23, particleItem);
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        String tag;
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory() || !MMOUtils.isMetaItem(item, false)) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Particle")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.ITEM_PARTICLES, "particle").enable("Write in the chat the particle you want.");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("item-particles.particle")) {
                this.getEditedSection().set("item-particles.particle", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the particle.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Particle Color")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.ITEM_PARTICLES, "particle-color").enable("Write in the chat the RGB color you want.", ChatColor.AQUA + "Format: [RED] [GREEN] [BLUE]");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("item-particles.color")) {
                this.getEditedSection().set("item-particles.color", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the particle color.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Particle Pattern")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.ITEM_PARTICLES, "particle-type").enable("Write in the chat the particle type you want.");
                this.player.sendMessage("");
                this.player.sendMessage("" + ChatColor.GREEN + ChatColor.BOLD + "Available Particles Patterns");
                for (ParticleType type : ParticleType.values()) {
                    this.player.sendMessage("* " + ChatColor.GREEN + type.name());
                }
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("item-particles.type")) {
                this.getEditedSection().set("item-particles.type", null);
                for (String key : this.getEditedSection().getConfigurationSection("item-particles").getKeys(false)) {
                    if (key.equals("particle")) continue;
                    this.getEditedSection().set("item-particles." + key, null);
                }
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the particle pattern.");
            }
        }
        if ((tag = (String)item.getItemMeta().getPersistentDataContainer().get(PATTERN_MODIFIED_KEY, PersistentDataType.STRING)) == null || tag.equals("")) {
            return;
        }
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(this, ItemStats.ITEM_PARTICLES, tag).enable("Write in the chat the value you want.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("item-particles." + tag)) {
            this.getEditedSection().set("item-particles." + tag, null);
            this.registerTemplateEdition();
            this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset " + ChatColor.GOLD + tag + ChatColor.GRAY + ".");
        }
    }
}

