/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.type.InternalStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemEdition
extends EditionInventory {
    private static final int[] slots = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final NamespacedKey STAT_ID_KEY = new NamespacedKey((Plugin)MMOItems.plugin, "StatId");

    public ItemEdition(Player player, MMOItemTemplate template) {
        super(player, template);
    }

    @Override
    public String getName() {
        return "Item Edition: " + this.getEdited().getId();
    }

    @Override
    public void arrangeInventory() {
        int min = (this.page - 1) * slots.length;
        int max = this.page * slots.length;
        int n = 0;
        List appliable = new ArrayList<ItemStat>(this.getEdited().getType().getAvailableStats()).stream().filter(stat -> stat.hasValidMaterial(this.getCachedItem()) && !(stat instanceof InternalStat)).collect(Collectors.toList());
        for (int j = min; j < Math.min(appliable.size(), max); ++j) {
            ItemStat stat2 = (ItemStat)appliable.get(j);
            ItemStack item = new ItemStack(stat2.getDisplayMaterial());
            ItemMeta meta = item.getItemMeta();
            meta.addItemFlags(ItemFlag.values());
            VersionUtils.addEmptyAttributeModifier((ItemMeta)meta);
            meta.setDisplayName(ChatColor.GREEN + stat2.getName());
            List lore = MythicLib.plugin.parseColors(Arrays.stream(stat2.getLore()).map(s -> ChatColor.GRAY + s).collect(Collectors.toList()));
            lore.add("");
            if (stat2.getCategory() != null) {
                lore.add(0, "");
                lore.add(0, ChatColor.BLUE + stat2.getCategory().getLoreTag());
            }
            stat2.whenDisplayed(lore, this.getEventualStatData(stat2));
            meta.getPersistentDataContainer().set(STAT_ID_KEY, PersistentDataType.STRING, (Object)stat2.getId());
            meta.setLore(lore);
            item.setItemMeta(meta);
            this.inventory.setItem(slots[n++], item);
        }
        ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        glassMeta.setDisplayName(ChatColor.RED + "- No Item Stat -");
        glass.setItemMeta(glassMeta);
        ItemStack next = new ItemStack(Material.ARROW);
        ItemMeta nextMeta = next.getItemMeta();
        nextMeta.setDisplayName(ChatColor.GREEN + "Next Page");
        next.setItemMeta(nextMeta);
        ItemStack previous = new ItemStack(Material.ARROW);
        ItemMeta previousMeta = previous.getItemMeta();
        previousMeta.setDisplayName(ChatColor.GREEN + "Previous Page");
        previous.setItemMeta(previousMeta);
        while (n < slots.length) {
            this.inventory.setItem(slots[n++], glass);
        }
        this.inventory.setItem(27, (ItemStack)(this.page > 1 ? previous : null));
        this.inventory.setItem(35, (ItemStack)(appliable.size() > max ? next : null));
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        String tag;
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory()) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (!MMOUtils.isMetaItem(item, false) || event.getInventory().getItem(4) == null) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Next Page")) {
            ++this.page;
            this.refreshInventory();
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Previous Page")) {
            --this.page;
            this.refreshInventory();
        }
        if ((tag = (String)item.getItemMeta().getPersistentDataContainer().get(STAT_ID_KEY, PersistentDataType.STRING)) == null || tag.isEmpty()) {
            return;
        }
        ItemStat<?, ?> edited = MMOItems.plugin.getStats().get(tag);
        if (MMOItems.plugin.hasPermissions() && MMOItems.plugin.getLanguage().opStatsEnabled && MMOItems.plugin.getLanguage().opStats.contains(edited.getId()) && !MMOItems.plugin.getVault().getPermissions().has((Player)event.getWhoClicked(), "mmoitems.edit.op")) {
            event.getWhoClicked().sendMessage(ChatColor.RED + "You are lacking permission to edit this stat.");
            return;
        }
        edited.whenClicked(this, event);
    }

    @Deprecated
    public ItemEdition onPage(int value) {
        this.page = value;
        return this;
    }
}

