/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.element.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.random.RandomElementListData;
import net.Indyuce.mmoitems.util.ElementStatType;
import net.Indyuce.mmoitems.util.MMOUtils;
import net.Indyuce.mmoitems.util.Pair;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ElementsEdition
extends EditionInventory {
    private final List<Element> elements = new ArrayList<Element>();
    private final int maxPage;
    private final Map<Integer, Pair<Element, ElementStatType>> editableStats = new HashMap<Integer, Pair<Element, ElementStatType>>();
    private int page = 1;
    private static final int[] INIT_SLOTS = new int[]{19, 28, 37};
    private static final int ELEMENTS_PER_PAGE = 3;

    public ElementsEdition(Player player, MMOItemTemplate template) {
        super(player, template);
        this.elements.addAll(MythicLib.plugin.getElements().getAll());
        this.maxPage = 1 + (MythicLib.plugin.getElements().getAll().size() - 1) / 3;
    }

    @Override
    public String getName() {
        return "Elements: " + this.template.getId();
    }

    @Override
    public void arrangeInventory() {
        int index;
        Optional statData = this.getEventualStatData(ItemStats.ELEMENTS);
        ItemStack prevPage = new ItemStack(Material.ARROW);
        ItemMeta prevPageMeta = prevPage.getItemMeta();
        prevPageMeta.setDisplayName(ChatColor.GREEN + "Previous Page");
        prevPage.setItemMeta(prevPageMeta);
        this.inventory.setItem(25, prevPage);
        ItemStack nextPage = new ItemStack(Material.ARROW);
        ItemMeta nextPageMeta = nextPage.getItemMeta();
        nextPageMeta.setDisplayName(ChatColor.GREEN + "Next Page");
        nextPage.setItemMeta(nextPageMeta);
        this.inventory.setItem(43, nextPage);
        this.editableStats.clear();
        int startingIndex = (this.page - 1) * 3;
        for (int i = 0; i < 3 && (index = startingIndex + i) < this.elements.size(); ++i) {
            Element element = this.elements.get(index);
            int k = 0;
            for (ElementStatType statType : ElementStatType.values()) {
                ItemStack statItem = new ItemStack(element.getIcon());
                ItemMeta statMeta = statItem.getItemMeta();
                statMeta.setDisplayName(ChatColor.GREEN + element.getName() + " " + statType.getName());
                ArrayList<String> statLore = new ArrayList<String>();
                statLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GREEN + (statData.isPresent() && ((RandomElementListData)statData.get()).hasStat(element, statType) ? ((RandomElementListData)statData.get()).getStat(element, statType) : "---"));
                statLore.add("");
                statLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
                statLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove this value.");
                statMeta.setLore(statLore);
                statItem.setItemMeta(statMeta);
                int slot = INIT_SLOTS[i] + k;
                this.inventory.setItem(slot, statItem);
                this.editableStats.put(slot, Pair.of(element, statType));
                ++k;
            }
        }
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory() || !MMOUtils.isMetaItem(item, false)) {
            return;
        }
        if (this.page > 1 && item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Previous Page")) {
            --this.page;
            this.refreshInventory();
            return;
        }
        if (this.page < this.maxPage && item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Next Page")) {
            ++this.page;
            this.refreshInventory();
            return;
        }
        Pair<Element, ElementStatType> edited = this.editableStats.get(event.getSlot());
        if (edited == null) {
            return;
        }
        String elementPath = edited.getValue().getConcatenatedConfigPath(edited.getKey());
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(this, ItemStats.ELEMENTS, elementPath).enable("Write in the value you want.");
        } else if (event.getAction() == InventoryAction.PICKUP_HALF) {
            this.getEditedSection().set("element." + elementPath, null);
            String elementName = edited.getKey().getId();
            if (this.getEditedSection().contains("element." + elementName) && this.getEditedSection().getConfigurationSection("element." + elementName).getKeys(false).isEmpty()) {
                this.getEditedSection().set("element." + elementName, null);
                if (this.getEditedSection().getConfigurationSection("element").getKeys(false).isEmpty()) {
                    this.getEditedSection().set("element", null);
                }
            }
            this.registerTemplateEdition();
            this.player.sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + edited.getKey().getName() + " " + edited.getValue().getName() + ChatColor.GRAY + " successfully removed.");
        }
    }
}

