/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ArrowParticlesEdition
extends EditionInventory {
    public ArrowParticlesEdition(Player player, MMOItemTemplate template) {
        super(player, template);
    }

    @Override
    public String getName() {
        return "Arrow Particles: " + this.template.getId();
    }

    @Override
    public void arrangeInventory() {
        Particle particle = null;
        try {
            particle = Particle.valueOf((String)this.getEditedSection().getString("arrow-particles.particle"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack particleItem = new ItemStack(Material.BLAZE_POWDER);
        ItemMeta particleItemMeta = particleItem.getItemMeta();
        particleItemMeta.setDisplayName(ChatColor.GREEN + "Particle");
        ArrayList<String> particleItemLore = new ArrayList<String>();
        particleItemLore.add(ChatColor.GRAY + "" + ChatColor.ITALIC + "The particle which is displayed around the");
        particleItemLore.add(ChatColor.GRAY + "" + ChatColor.ITALIC + "arrow. Fades away when the arrow lands.");
        particleItemLore.add("");
        particleItemLore.add(ChatColor.GRAY + "Current Value: " + (particle == null ? ChatColor.RED + "No particle selected." : ChatColor.GOLD + UtilityMethods.caseOnWords((String)particle.name().toLowerCase().replace("_", " "))));
        particleItemLore.add("");
        particleItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
        particleItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
        particleItemMeta.setLore(particleItemLore);
        particleItem.setItemMeta(particleItemMeta);
        ItemStack amount = new ItemStack(Material.GRAY_DYE);
        ItemMeta amountMeta = amount.getItemMeta();
        amountMeta.setDisplayName(ChatColor.GREEN + "Amount");
        ArrayList<String> amountLore = new ArrayList<String>();
        amountLore.add("");
        amountLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GOLD + this.getEditedSection().getInt("arrow-particles.amount"));
        amountLore.add("");
        amountLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
        amountLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
        amountMeta.setLore(amountLore);
        amount.setItemMeta(amountMeta);
        ItemStack offset = new ItemStack(Material.GRAY_DYE);
        ItemMeta offsetMeta = offset.getItemMeta();
        offsetMeta.setDisplayName(ChatColor.GREEN + "Offset");
        ArrayList<String> offsetLore = new ArrayList<String>();
        offsetLore.add("");
        offsetLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GOLD + this.getEditedSection().getDouble("arrow-particles.offset"));
        offsetLore.add("");
        offsetLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
        offsetLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
        offsetMeta.setLore(offsetLore);
        offset.setItemMeta(offsetMeta);
        if (particle != null) {
            ConfigurationSection section = this.getEditedSection().getConfigurationSection("arrow-particles");
            if (MMOUtils.isColorable(particle)) {
                int red = section.getInt("color.red");
                int green = section.getInt("color.green");
                int blue = section.getInt("color.blue");
                ItemStack speed = new ItemStack(Material.GRAY_DYE);
                ItemMeta speedMeta = speed.getItemMeta();
                speedMeta.setDisplayName(ChatColor.GREEN + "Particle Color");
                ArrayList<String> speedLore = new ArrayList<String>();
                speedLore.add("");
                speedLore.add(ChatColor.GRAY + "Current Value (R-G-B):");
                speedLore.add("" + ChatColor.RED + ChatColor.BOLD + red + ChatColor.GRAY + " - " + ChatColor.GREEN + ChatColor.BOLD + green + ChatColor.GRAY + " - " + ChatColor.BLUE + ChatColor.BOLD + blue);
                speedLore.add("");
                speedLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
                speedLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
                speedMeta.setLore(speedLore);
                speed.setItemMeta(speedMeta);
                this.inventory.setItem(41, speed);
            } else {
                ItemStack colorItem = new ItemStack(Material.GRAY_DYE);
                ItemMeta colorItemMeta = colorItem.getItemMeta();
                colorItemMeta.setDisplayName(ChatColor.GREEN + "Speed");
                ArrayList<String> colorItemLore = new ArrayList<String>();
                colorItemLore.add(ChatColor.GRAY + "" + ChatColor.ITALIC + "The speed at which your particle");
                colorItemLore.add(ChatColor.GRAY + "" + ChatColor.ITALIC + "flies off in random directions.");
                colorItemLore.add("");
                colorItemLore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GOLD + section.getDouble("speed"));
                colorItemLore.add("");
                colorItemLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
                colorItemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to reset.");
                colorItemMeta.setLore(colorItemLore);
                colorItem.setItemMeta(colorItemMeta);
                this.inventory.setItem(41, colorItem);
            }
        }
        this.inventory.setItem(30, particleItem);
        this.inventory.setItem(23, amount);
        this.inventory.setItem(32, offset);
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory() || !MMOUtils.isMetaItem(item, false)) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Particle")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.ARROW_PARTICLES, "particle").enable("Write in the chat the particle you want.");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("arrow-particles.particle")) {
                this.getEditedSection().set("arrow-particles", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the particle.");
            }
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Particle Color")) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.ARROW_PARTICLES, "color").enable("Write in the chat the RGB color you want.", ChatColor.AQUA + "Format: [RED] [GREEN] [BLUE]");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("arrow-particles.color")) {
                this.getEditedSection().set("arrow-particles.color", null);
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the particle color.");
            }
        }
        for (String string : new String[]{"amount", "offset", "speed"}) {
            if (!item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + UtilityMethods.caseOnWords((String)string))) continue;
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.ARROW_PARTICLES, string).enable("Write in the chat the " + string + " you want.");
            }
            if (event.getAction() != InventoryAction.PICKUP_HALF || !this.getEditedSection().contains("arrow-particles." + string)) continue;
            this.getEditedSection().set("arrow-particles." + string, null);
            this.registerTemplateEdition();
            this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the " + string + ".");
        }
    }
}

