/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.util.AdventureUtils;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.edition.NewItemEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.PluginInventory;
import net.Indyuce.mmoitems.gui.edition.ItemEdition;
import net.Indyuce.mmoitems.stat.BrowserDisplayIDX;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ItemBrowser
extends PluginInventory {
    private final Map<String, ItemStack> cached = new LinkedHashMap<String, ItemStack>();
    private final List<Type> itemTypes;
    private final Type type;
    private boolean deleteMode;
    private static final int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    private static final int[] slotsAlt = new int[]{1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    private static final String CUSTOM_RP_DOWNLOAD_LINK = "https://www.dropbox.com/s/90w9pvdbfeyxu94/MICustomBlockPack.zip?dl=1";
    private static final NamespacedKey TYPE_ID_KEY = new NamespacedKey((Plugin)MMOItems.plugin, "TypeId");

    public ItemBrowser(Player player) {
        this(player, null);
    }

    public ItemBrowser(Player player, Type type) {
        super(player);
        this.type = type;
        this.itemTypes = MMOItems.plugin.getTypes().getAll().stream().filter(Type::isDisplayed).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        if (this.type == null) {
            int[] usedSlots = slots;
            int min = (this.page - 1) * usedSlots.length;
            int max = this.page * usedSlots.length;
            int n = 0;
            Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)"Item Explorer");
            for (int j = min; j < Math.min(max, this.itemTypes.size()); ++j) {
                Type currentType = this.itemTypes.get(j);
                int items = MMOItems.plugin.getTemplates().getTemplates(currentType).size();
                ItemStack item = currentType.getItem();
                item.setAmount(Math.max(1, Math.min(64, items)));
                ItemMeta meta = item.getItemMeta();
                if (MythicLib.plugin.getVersion().isAbove(new int[]{1, 20, 5})) {
                    VersionUtils.addEmptyAttributeModifier((ItemMeta)meta);
                }
                AdventureUtils.setDisplayName((ItemMeta)meta, (String)String.format("&a%s&8 (click to browse)", currentType.getName()));
                meta.addItemFlags(ItemFlag.values());
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(String.format("&7&oThere %s %s &7&oitem%s in this type.", items == 1 ? "is" : "are", items < 1 ? "&c&ono" : "&6&o" + items, items == 1 ? "" : "s"));
                AdventureUtils.setLore((ItemMeta)meta, lore);
                meta.getPersistentDataContainer().set(TYPE_ID_KEY, PersistentDataType.STRING, (Object)currentType.getId());
                item.setItemMeta(meta);
                inv.setItem(slots[n++], item);
            }
            ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
            ItemMeta glassMeta = glass.getItemMeta();
            glassMeta.setDisplayName(ChatColor.RED + "- No type -");
            glass.setItemMeta(glassMeta);
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = next.getItemMeta();
            nextMeta.setDisplayName(ChatColor.GREEN + "Next Page");
            next.setItemMeta(nextMeta);
            ItemStack previous = new ItemStack(Material.ARROW);
            ItemMeta previousMeta = previous.getItemMeta();
            previousMeta.setDisplayName(ChatColor.GREEN + "Previous Page");
            previous.setItemMeta(previousMeta);
            while (n < slots.length) {
                inv.setItem(slots[n++], glass);
            }
            inv.setItem(18, (ItemStack)(this.page > 1 ? previous : null));
            inv.setItem(26, max >= MMOItems.plugin.getTypes().getAll().size() ? null : next);
            return inv;
        }
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)((this.deleteMode ? "Delete Mode: " : "Item Explorer: ") + MythicLib.plugin.getAdventureParser().stripColors(this.type.getName())));
        ItemStack error = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta errorMeta = error.getItemMeta();
        errorMeta.setDisplayName(ChatColor.RED + "- Error -");
        ArrayList<String> errorLore = new ArrayList<String>();
        errorLore.add("\u00a7\u00a7oAn error occurred while");
        errorLore.add("\u00a7\u00a7otrying to generate that item.");
        errorMeta.setLore(errorLore);
        error.setItemMeta(errorMeta);
        ItemStack noItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta noItemMeta = noItem.getItemMeta();
        noItemMeta.setDisplayName(ChatColor.RED + "- No Item -");
        noItem.setItemMeta(noItemMeta);
        ItemStack next = new ItemStack(Material.ARROW);
        ItemMeta nextMeta = next.getItemMeta();
        nextMeta.setDisplayName(ChatColor.GREEN + "Next Page");
        next.setItemMeta(nextMeta);
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        backMeta.setDisplayName(ChatColor.GREEN + "\u21e8" + " Back");
        back.setItemMeta(backMeta);
        ItemStack create = new ItemStack(new ItemStack(Material.WRITABLE_BOOK));
        ItemMeta createMeta = create.getItemMeta();
        createMeta.setDisplayName(ChatColor.GREEN + "Create New");
        create.setItemMeta(createMeta);
        ItemStack delete = new ItemStack(new ItemStack(Material.CAULDRON));
        ItemMeta deleteMeta = delete.getItemMeta();
        deleteMeta.setDisplayName(ChatColor.RED + (this.deleteMode ? "Cancel Deletion" : "Delete Item"));
        delete.setItemMeta(deleteMeta);
        ItemStack previous = new ItemStack(Material.ARROW);
        ItemMeta previousMeta = previous.getItemMeta();
        previousMeta.setDisplayName(ChatColor.GREEN + "Previous Page");
        previous.setItemMeta(previousMeta);
        if (this.type == Type.BLOCK) {
            ItemStack downloadPack = new ItemStack(Material.HOPPER);
            ItemMeta downloadMeta = downloadPack.getItemMeta();
            downloadMeta.setDisplayName(ChatColor.GREEN + "Download Default Resourcepack");
            downloadMeta.setLore(Arrays.asList(ChatColor.LIGHT_PURPLE + "Only seeing stone blocks?", "", ChatColor.RED + "By downloading the default resourcepack you can", ChatColor.RED + "edit the blocks however you want.", ChatColor.RED + "You will still have to add it to your server!"));
            downloadPack.setItemMeta(downloadMeta);
            inv.setItem(45, downloadPack);
        }
        HashMap<Double, ArrayList<MMOItemTemplate>> templates = BrowserDisplayIDX.select(MMOItems.plugin.getTemplates().getTemplates(this.type));
        int[] usedSlots = this.type.isFourGUIMode() ? slotsAlt : slots;
        int min = (this.page - 1) * usedSlots.length;
        int max = this.page * usedSlots.length;
        int n = 0;
        int sc = this.type.isFourGUIMode() ? 4 : 3;
        int totalSpaceCount = 0;
        for (Map.Entry<Double, ArrayList<MMOItemTemplate>> indexTemplates : templates.entrySet()) {
            for (int totalSpaceAdd = indexTemplates.getValue().size(); totalSpaceAdd > 0; totalSpaceAdd -= sc) {
                totalSpaceCount += sc;
            }
        }
        for (int j = min; j < Math.min(max, totalSpaceCount); ++j) {
            MMOItemTemplate template = BrowserDisplayIDX.getAt(j, templates);
            if (template == null) {
                inv.setItem(usedSlots[n], noItem);
                if ((n += 7) < usedSlots.length) continue;
                n -= 7 * sc;
                ++n;
                continue;
            }
            ItemStack item = template.newBuilder(this.playerData.getRPG(), true).build().newBuilder().build();
            if (item == null || item.getType().isAir() || !item.getType().isItem() || item.getItemMeta() == null) {
                this.cached.put(template.getId(), error);
                inv.setItem(usedSlots[n], error);
                if ((n += 7) < usedSlots.length) continue;
                n -= 7 * sc;
                ++n;
                continue;
            }
            ItemMeta meta = item.getItemMeta();
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add("");
            if (this.deleteMode) {
                lore.add(ChatColor.RED + "\u2716" + " CLICK TO DELETE " + "\u2716");
                meta.setDisplayName(ChatColor.RED + "DELETE: " + (meta.hasDisplayName() ? meta.getDisplayName() : MMOUtils.getDisplayName(item)));
            } else {
                lore.add(ChatColor.YELLOW + "\u25b8" + " Left click to obtain this item.");
                lore.add(ChatColor.YELLOW + "\u25b8" + " Right click to edit this item.");
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            this.cached.put(template.getId(), item);
            inv.setItem(usedSlots[n], this.cached.get(template.getId()));
            if ((n += 7) < usedSlots.length) continue;
            n -= 7 * sc;
            ++n;
        }
        if (!this.deleteMode) {
            inv.setItem(51, create);
        }
        inv.setItem(47, delete);
        inv.setItem(49, back);
        inv.setItem(18, (ItemStack)(this.page > 1 ? previous : null));
        inv.setItem(26, max >= totalSpaceCount ? null : next);
        for (int i : usedSlots) {
            if (!SilentNumbers.isAir((ItemStack)inv.getItem(i))) continue;
            inv.setItem(i, noItem);
        }
        return inv;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        String id;
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory()) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (MMOUtils.isMetaItem(item, false)) {
            if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Next Page")) {
                ++this.page;
                this.open();
            } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Previous Page")) {
                --this.page;
                this.open();
            } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "\u21e8" + " Back")) {
                new ItemBrowser(this.getPlayer()).open();
            } else if (item.getItemMeta().getDisplayName().equals(ChatColor.RED + "Cancel Deletion")) {
                this.deleteMode = false;
                this.open();
            } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Create New")) {
                new NewItemEdition(this).enable("Write in the chat the text you want.");
            } else if (this.type != null && item.getItemMeta().getDisplayName().equals(ChatColor.RED + "Delete Item")) {
                this.deleteMode = true;
                this.open();
            } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Download Default Resourcepack")) {
                MythicLib.plugin.getVersion().getWrapper().sendJson(this.getPlayer(), "[{\"text\":\"Click to download!\",\"color\":\"green\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"https://www.dropbox.com/s/90w9pvdbfeyxu94/MICustomBlockPack.zip?dl=1\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":[\"\",{\"text\":\"Click to download via Dropbox\",\"italic\":true,\"color\":\"white\"}]}}]");
                this.getPlayer().closeInventory();
            } else if (this.type == null && !item.getItemMeta().getDisplayName().equals(ChatColor.RED + "- No type -")) {
                String typeId = (String)item.getItemMeta().getPersistentDataContainer().get(TYPE_ID_KEY, PersistentDataType.STRING);
                new ItemBrowser(this.getPlayer(), MMOItems.plugin.getTypes().get(typeId)).open();
            }
        }
        if ((id = NBTItem.get((ItemStack)item).getString("MMOITEMS_ITEM_ID")).equals("")) {
            return;
        }
        if (this.deleteMode) {
            MMOItems.plugin.getTemplates().deleteTemplate(this.type, id);
            this.deleteMode = false;
            this.open();
        } else {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                this.getPlayer().getInventory().addItem(new ItemStack[]{MMOItems.plugin.getItem(this.type, id, this.playerData)});
                this.getPlayer().playSound(this.getPlayer().getLocation(), Sounds.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 2.0f);
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF) {
                new ItemEdition(this.getPlayer(), MMOItems.plugin.getTemplates().getTemplate(this.type, id)).open();
            }
        }
    }
}

