/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.SmartGive;
import io.lumine.mythic.lib.version.Sounds;
import java.util.List;
import java.util.UUID;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.CustomSound;
import net.Indyuce.mmoitems.api.crafting.CraftingStation;
import net.Indyuce.mmoitems.api.crafting.CraftingStatus;
import net.Indyuce.mmoitems.api.crafting.Layout;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.IngredientInventory;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.CraftingRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.Recipe;
import net.Indyuce.mmoitems.api.event.PlayerUseCraftingStationEvent;
import net.Indyuce.mmoitems.api.item.util.ConfigItems;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.comp.eco.MoneyCondition;
import net.Indyuce.mmoitems.gui.CraftingStationPreview;
import net.Indyuce.mmoitems.gui.PluginInventory;
import net.Indyuce.mmoitems.listener.CustomSoundListener;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingStationView
extends PluginInventory {
    private final CraftingStation station;
    private final Layout layout;
    private List<CheckedRecipe> recipes;
    private IngredientInventory ingredients;
    private int queueOffset;

    public CraftingStationView(Player player, CraftingStation station, int page) {
        super(player);
        this.station = station;
        this.layout = station.getLayout();
        this.page = page;
        this.updateData();
    }

    public CraftingStation getStation() {
        return this.station;
    }

    void updateData() {
        this.ingredients = new IngredientInventory(this.player);
        this.recipes = this.station.getAvailableRecipes(this.playerData, this.ingredients);
    }

    @Override
    public Inventory getInventory() {
        int j;
        String title = MythicLib.plugin.parseColors(MythicLib.plugin.getPlaceholderParser().parse((OfflinePlayer)this.getPlayer(), this.station.getName().replace("#page#", "" + this.page).replace("#max#", "" + this.station.getMaxPage())));
        final Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)this.layout.getSize(), (String)title);
        int min = (this.page - 1) * this.layout.getRecipeSlots().size();
        int max = this.page * this.layout.getRecipeSlots().size();
        for (int j2 = min; j2 < max; ++j2) {
            if (j2 >= this.recipes.size()) {
                if (!this.station.getItemOptions().hasNoRecipe()) continue;
                inv.setItem(this.layout.getRecipeSlots().get(j2 - min).intValue(), this.station.getItemOptions().getNoRecipe());
                continue;
            }
            inv.setItem(this.layout.getRecipeSlots().get(j2 - min).intValue(), this.recipes.get(j2).display());
        }
        if (max < this.recipes.size()) {
            inv.setItem(this.layout.getRecipeNextSlot(), ConfigItems.NEXT_PAGE.getItem());
        }
        if (this.page > 1) {
            inv.setItem(this.layout.getRecipePreviousSlot(), ConfigItems.PREVIOUS_PAGE.getItem());
        }
        final CraftingStatus.CraftingQueue queue = this.playerData.getCrafting().getQueue(this.station);
        for (j = this.queueOffset; j < this.queueOffset + this.layout.getQueueSlots().size(); ++j) {
            if (j >= queue.getCrafts().size()) {
                if (!this.station.getItemOptions().hasNoQueueItem()) continue;
                inv.setItem(this.layout.getQueueSlots().get(j - this.queueOffset).intValue(), this.station.getItemOptions().getNoQueueItem());
                continue;
            }
            inv.setItem(this.layout.getQueueSlots().get(j - this.queueOffset).intValue(), ConfigItems.QUEUE_ITEM_DISPLAY.newBuilder(queue.getCrafts().get(j), j + 1).build());
        }
        if (this.queueOffset + this.layout.getQueueSlots().size() < queue.getCrafts().size()) {
            inv.setItem(this.layout.getQueueNextSlot(), ConfigItems.NEXT_IN_QUEUE.getItem());
        }
        if (this.queueOffset > 0) {
            inv.setItem(this.layout.getQueuePreviousSlot(), ConfigItems.PREVIOUS_IN_QUEUE.getItem());
        }
        new BukkitRunnable(){

            public void run() {
                if (inv.getViewers().isEmpty()) {
                    this.cancel();
                    return;
                }
                for (int j = CraftingStationView.this.queueOffset; j < CraftingStationView.this.queueOffset + CraftingStationView.this.layout.getQueueSlots().size(); ++j) {
                    if (j >= queue.getCrafts().size()) {
                        inv.setItem(CraftingStationView.this.layout.getQueueSlots().get(j - CraftingStationView.this.queueOffset).intValue(), CraftingStationView.this.station.getItemOptions().hasNoQueueItem() ? CraftingStationView.this.station.getItemOptions().getNoQueueItem() : null);
                        continue;
                    }
                    inv.setItem(CraftingStationView.this.layout.getQueueSlots().get(j - CraftingStationView.this.queueOffset).intValue(), ConfigItems.QUEUE_ITEM_DISPLAY.newBuilder(queue.getCrafts().get(j), j + 1).build());
                }
            }
        }.runTaskTimer((Plugin)MMOItems.plugin, 0L, 20L);
        if (this.station.getItemOptions().hasFill()) {
            for (j = 0; j < this.layout.getSize(); ++j) {
                if (inv.getItem(j) != null && inv.getItem(j).getType() != Material.AIR) continue;
                inv.setItem(j, this.station.getItemOptions().getFill());
            }
        }
        return inv;
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        if (!this.playerData.isOnline()) {
            return;
        }
        event.setCancelled(true);
        if (!MMOUtils.isMetaItem(event.getCurrentItem(), false)) {
            return;
        }
        NBTItem nbtItem = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getCurrentItem());
        if (nbtItem.getString("ItemId").equals("PREVIOUS_IN_QUEUE")) {
            --this.queueOffset;
            this.open();
            return;
        }
        if (nbtItem.getString("ItemId").equals("NEXT_IN_QUEUE")) {
            ++this.queueOffset;
            this.open();
            return;
        }
        if (nbtItem.getString("ItemId").equals("NEXT_PAGE")) {
            ++this.page;
            this.open();
            return;
        }
        if (nbtItem.getString("ItemId").equals("PREVIOUS_PAGE")) {
            --this.page;
            this.open();
            return;
        }
        NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getCurrentItem());
        String tag = item.getString("recipeId");
        if (!tag.isEmpty()) {
            this.updateData();
            CheckedRecipe recipe = this.getRecipe(tag);
            if (event.isRightClick()) {
                new CraftingStationPreview(this, recipe).open();
            } else {
                this.processRecipe(recipe);
                this.open();
            }
        } else {
            tag = item.getString("queueId");
            if (!tag.isEmpty()) {
                CraftingStatus.CraftingQueue.QueueItem recipeInfo = this.playerData.getCrafting().getQueue(this.station).getCraft(UUID.fromString(tag));
                CraftingRecipe recipe = recipeInfo.getRecipe();
                if (recipeInfo.isReady()) {
                    ItemStack result = recipe.hasOption(Recipe.RecipeOption.OUTPUT_ITEM) ? recipe.getOutputItemStack(this.playerData.getRPG()) : null;
                    PlayerUseCraftingStationEvent called = new PlayerUseCraftingStationEvent(this.playerData, this.station, recipe, result);
                    Bukkit.getPluginManager().callEvent((Event)called);
                    if (called.isCancelled()) {
                        return;
                    }
                    this.playerData.getCrafting().getQueue(this.station).remove(recipeInfo);
                    recipe.whenClaimed().forEach(trigger -> trigger.whenCrafting(this.playerData));
                    CustomSoundListener.playSound(result, CustomSound.ON_CRAFT, this.player);
                    if (!recipe.hasOption(Recipe.RecipeOption.SILENT_CRAFT)) {
                        this.player.playSound(this.player.getLocation(), this.station.getSound(), 1.0f, 1.0f);
                    }
                    if (result != null) {
                        new SmartGive(this.player).give(new ItemStack[]{result});
                    }
                } else {
                    PlayerUseCraftingStationEvent called = new PlayerUseCraftingStationEvent(this.playerData, this.station, recipe);
                    Bukkit.getPluginManager().callEvent((Event)called);
                    if (called.isCancelled()) {
                        return;
                    }
                    this.playerData.getCrafting().getQueue(this.station).remove(recipeInfo);
                    recipe.whenCanceled().forEach(trigger -> trigger.whenCrafting(this.playerData));
                    if (!recipe.hasOption(Recipe.RecipeOption.SILENT_CRAFT)) {
                        this.player.playSound(this.player.getLocation(), this.station.getSound(), 1.0f, 1.0f);
                    }
                    for (Ingredient ingredient : recipeInfo.getRecipe().getIngredients()) {
                        new SmartGive(this.player).give(new ItemStack[]{ingredient.generateItemStack(this.playerData.getRPG(), false)});
                    }
                    recipe.getConditions().stream().filter(condition -> condition instanceof MoneyCondition).map(condition -> (MoneyCondition)condition).forEach(condition -> MMOItems.plugin.getVault().getEconomy().depositPlayer((OfflinePlayer)this.player, condition.getAmount()));
                }
                this.updateData();
                this.open();
            }
        }
    }

    public void processRecipe(CheckedRecipe recipe) {
        if (!recipe.areConditionsMet()) {
            Message.CONDITIONS_NOT_MET.format(ChatColor.RED, new String[0]).send(this.player);
            this.player.playSound(this.player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        if (!recipe.allIngredientsHad()) {
            Message.NOT_ENOUGH_MATERIALS.format(ChatColor.RED, new String[0]).send(this.player);
            this.player.playSound(this.player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        if (!recipe.getRecipe().canUse(this.playerData, this.ingredients, recipe, this.station)) {
            this.updateData();
            return;
        }
        if (recipe.getRecipe().whenUsed(this.playerData, this.ingredients, recipe, this.station)) {
            recipe.getIngredients().forEach(ingredient -> ingredient.takeAway());
            recipe.getConditions().forEach(condition -> condition.getCondition().whenCrafting(this.playerData));
            recipe.getRecipe().whenUsed().forEach(trigger -> trigger.whenCrafting(this.playerData));
            this.updateData();
        }
    }

    @Nullable
    private CheckedRecipe getRecipe(@NotNull String id) {
        for (CheckedRecipe info : this.recipes) {
            if (!info.getRecipe().getId().equals(id)) continue;
            return info;
        }
        return null;
    }
}

