/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.api.MMOLineConfig;
import java.util.Optional;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import net.Indyuce.mmocore.experience.source.type.SpecificExperienceSource;
import net.Indyuce.mmocore.manager.profession.ExperienceSourceManager;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class MineMIBlockExperienceSource
extends SpecificExperienceSource<Integer> {
    private final int id;
    private final boolean silkTouch;
    private final boolean playerPlaced;

    public MineMIBlockExperienceSource(ExperienceDispenser dispenser, MMOLineConfig config) {
        super(dispenser, config);
        config.validate(new String[]{"id"});
        this.id = config.getInt("id", 1);
        this.silkTouch = config.getBoolean("silk-touch", true);
        this.playerPlaced = config.getBoolean("player-placed", false);
    }

    public ExperienceSourceManager<MineMIBlockExperienceSource> newManager() {
        return new ExperienceSourceManager<MineMIBlockExperienceSource>(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void a(BlockBreakEvent event) {
                if (event.getPlayer().getGameMode() != GameMode.SURVIVAL) {
                    return;
                }
                PlayerData data = PlayerData.get((OfflinePlayer)event.getPlayer());
                Optional<CustomBlock> customBlock = MMOItems.plugin.getCustomBlocks().getFromBlock(event.getBlock().getBlockData());
                if (!customBlock.isPresent()) {
                    return;
                }
                for (MineMIBlockExperienceSource source : this.getSources()) {
                    if (source.silkTouch && MineMIBlockExperienceSource.this.hasSilkTouch(event.getPlayer().getInventory().getItemInMainHand()) || !source.playerPlaced && event.getBlock().hasMetadata("player_placed") || !source.matches(data, customBlock.get().getId())) continue;
                    source.giveExperience(data, 1.0, event.getBlock().getLocation());
                }
            }
        };
    }

    private boolean hasSilkTouch(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
    }

    public boolean matchesParameter(PlayerData player, Integer blockId) {
        return this.id == blockId;
    }
}

