/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.loot.LootBuilder;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.comp.mmocore.load.ItemGenerationDropItem;
import net.Indyuce.mmoitems.stat.data.SoulboundData;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class ItemTemplateDropItem
extends ItemGenerationDropItem {
    private final MMOItemTemplate template;

    public ItemTemplateDropItem(MMOLineConfig config) {
        super(config);
        config.validate(new String[]{"type", "id"});
        String format = config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_");
        Validate.isTrue((boolean)MMOItems.plugin.getTypes().has(format), (String)("Could not find item type with ID '" + format + "'"));
        Type type = MMOItems.plugin.getTypes().get(format);
        String id = config.getString("id").replace("-", "_").toUpperCase();
        Validate.isTrue((boolean)MMOItems.plugin.getTemplates().hasTemplate(type, id), (String)("Could not find MMOItem with ID '" + id + "'"));
        this.template = MMOItems.plugin.getTemplates().getTemplate(type, id);
    }

    public void collect(LootBuilder builder) {
        RPGPlayer rpgPlayer = PlayerData.get((OfflinePlayer)builder.getEntity().getPlayer()).getRPG();
        MMOItem mmoitem = this.rollMMOItem(this.template, rpgPlayer);
        if (this.rollSoulbound()) {
            mmoitem.setData(ItemStats.SOULBOUND, new SoulboundData(rpgPlayer.getPlayer(), 1));
        }
        ItemStack stack = this.rollUnidentification(mmoitem);
        stack.setAmount(this.rollAmount());
        builder.addLoot(stack);
    }
}

