/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.item.NBTItem;
import net.Indyuce.mmocore.loot.droptable.dropitem.DropItem;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ItemGenerationDropItem
extends DropItem {
    protected final int level;
    protected final ItemTier tier;
    private final double unidentified;
    private final double soulbound;

    public ItemGenerationDropItem(MMOLineConfig config) {
        super(config);
        this.level = config.getInt("level", 0);
        if (config.contains("tier")) {
            String format = config.getString("tier").toUpperCase().replace("-", "_").replace(" ", "_");
            Validate.isTrue((boolean)MMOItems.plugin.getTiers().has(format), (String)("Could not find item tier with ID '" + format + "'"));
            this.tier = MMOItems.plugin.getTiers().get(format);
        } else {
            this.tier = null;
        }
        this.unidentified = config.getDouble("unidentified", 0.0);
        this.soulbound = config.getDouble("soulbound", 0.0);
    }

    @NotNull
    public MMOItem rollMMOItem(MMOItemTemplate template, RPGPlayer rpgPlayer) {
        int itemLevel;
        int n = this.level > 0 ? this.level : (itemLevel = template.hasOption(MMOItemTemplate.TemplateOption.LEVEL_ITEM) ? MMOItems.plugin.getTemplates().rollLevel(rpgPlayer.getLevel()) : 0);
        ItemTier itemTier = this.tier != null ? this.tier : (template.hasOption(MMOItemTemplate.TemplateOption.TIERED) ? MMOItems.plugin.getTemplates().rollTier() : null);
        return new MMOItemBuilder(template, itemLevel, itemTier).build();
    }

    @NotNull
    public ItemStack rollUnidentification(MMOItem mmoitem) {
        ItemStack item = mmoitem.newBuilder().build();
        if (random.nextDouble() < this.unidentified) {
            item = mmoitem.getType().getUnidentifiedTemplate().newBuilder(NBTItem.get((ItemStack)item)).build();
        }
        return item;
    }

    public boolean rollSoulbound() {
        return random.nextDouble() < this.soulbound;
    }
}

