/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.item.NBTItem;
import net.Indyuce.mmocore.api.quest.ObjectiveProgress;
import net.Indyuce.mmocore.api.quest.QuestProgress;
import net.Indyuce.mmocore.api.quest.objective.Objective;
import net.Indyuce.mmocore.comp.citizens.CitizenInteractEvent;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class GetMMOItemObjective
extends Objective {
    private final Type type;
    private final String id;
    private final int required;
    private final int npcId;

    public GetMMOItemObjective(ConfigurationSection section, MMOLineConfig config) {
        super(section);
        config.validate(new String[]{"type", "id", "npc"});
        String format = config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_");
        Validate.isTrue((boolean)MMOItems.plugin.getTypes().has(format), (String)("Could not find item type " + format));
        this.type = MMOItems.plugin.getTypes().get(format);
        this.id = config.getString("id");
        this.required = config.contains("amount") ? Math.max(config.getInt("amount"), 1) : 1;
        this.npcId = config.getInt("npc");
    }

    public ObjectiveProgress newProgress(QuestProgress questProgress) {
        return new GotoProgress(questProgress, this);
    }

    public class GotoProgress
    extends ObjectiveProgress
    implements Listener {
        public GotoProgress(QuestProgress questProgress, Objective objective) {
            super(questProgress, objective);
        }

        @EventHandler
        public void a(CitizenInteractEvent event) {
            int amount;
            NBTItem item;
            Player player = event.getPlayer();
            if (!this.getQuestProgress().getPlayer().isOnline()) {
                return;
            }
            if (player.equals((Object)this.getQuestProgress().getPlayer().getPlayer()) && event.getNPC().getId() == GetMMOItemObjective.this.npcId && player.getInventory().getItemInMainHand() != null && (item = NBTItem.get((ItemStack)player.getInventory().getItemInMainHand())).getString("MMOITEMS_ITEM_TYPE").equals(GetMMOItemObjective.this.type.getId()) && item.getString("MMOITEMS_ITEM_ID").equals(GetMMOItemObjective.this.id) && (amount = player.getInventory().getItemInMainHand().getAmount()) >= GetMMOItemObjective.this.required) {
                if (amount <= GetMMOItemObjective.this.required) {
                    player.getInventory().setItemInMainHand(null);
                } else {
                    player.getInventory().getItemInMainHand().setAmount(amount - GetMMOItemObjective.this.required);
                }
                this.getQuestProgress().completeObjective();
            }
        }

        public String formatLore(String lore) {
            return lore;
        }
    }
}

