/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.crafting;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.attribute.PlayerAttribute;
import net.Indyuce.mmoitems.api.crafting.condition.Condition;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;

public class AttributeCondition
extends Condition {
    private final PlayerAttribute attribute;
    private final int points;

    public AttributeCondition(MMOLineConfig config) {
        super("attribute");
        config.validate(new String[]{"attribute", "points"});
        this.points = config.getInt("points");
        String id = config.getString("attribute").toLowerCase().replace("_", "-");
        Validate.isTrue((boolean)MMOCore.plugin.attributeManager.has(id), (String)("Could not find attribute " + id));
        this.attribute = MMOCore.plugin.attributeManager.get(id);
    }

    @Override
    public String formatDisplay(String string) {
        return string.replace("#level#", "" + this.points).replace("#attribute#", this.attribute.getName());
    }

    @Override
    public boolean isMet(net.Indyuce.mmoitems.api.player.PlayerData data) {
        return PlayerData.get((OfflinePlayer)data.getPlayer()).getAttributes().getAttribute(this.attribute) >= this.points;
    }

    @Override
    public void whenCrafting(net.Indyuce.mmoitems.api.player.PlayerData data) {
    }
}

