/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.player.inventory.EquippedItem;
import net.Indyuce.mmoitems.comp.inventory.PlayerInventory;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerInventoryHandler {
    @NotNull
    private final List<PlayerInventory> registeredInventories = new ArrayList<PlayerInventory>();

    public void register(@NotNull PlayerInventory pInventory) {
        this.registeredInventories.add(pInventory);
        if (pInventory instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)pInventory, (Plugin)MMOItems.plugin);
        }
    }

    public void unregisterIf(Predicate<PlayerInventory> filter) {
        Iterator<PlayerInventory> iterator = this.registeredInventories.iterator();
        while (iterator.hasNext()) {
            PlayerInventory next = iterator.next();
            if (!filter.test(next)) continue;
            if (next instanceof Listener) {
                HandlerList.unregisterAll((Listener)((Listener)next));
            }
            iterator.remove();
        }
    }

    public void unregisterAll() {
        for (PlayerInventory inv : this.registeredInventories) {
            if (!(inv instanceof Listener)) continue;
            HandlerList.unregisterAll((Listener)((Listener)inv));
        }
        this.registeredInventories.clear();
    }

    public ArrayList<PlayerInventory> getAll() {
        return new ArrayList<PlayerInventory>(this.registeredInventories);
    }

    @NotNull
    public List<EquippedItem> getInventory(@NotNull Player player) {
        ArrayList<EquippedItem> cummulative = new ArrayList<EquippedItem>();
        for (PlayerInventory inv : this.registeredInventories) {
            cummulative.addAll(inv.getInventory(player));
        }
        return cummulative;
    }
}

