/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.enchants;

import io.lumine.mythic.lib.api.item.ItemTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.comp.enchants.CrazyEnchantsData;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.type.InternalStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrazyEnchantsStat
extends ItemStat<RandomStatData<CrazyEnchantsData>, CrazyEnchantsData>
implements InternalStat {
    public CrazyEnchantsStat() {
        super("CRAZY_ENCHANTS", Material.BOOK, "Advanced Enchants", new String[0], new String[0], new Material[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull CrazyEnchantsData data) {
        Map<CEnchantment, Integer> enchants = data.getEnchants();
        for (Map.Entry<CEnchantment, Integer> entry : enchants.entrySet()) {
            CEnchantment enchantment = entry.getKey();
            int level = entry.getValue();
            item.getLore().insert(0, Methods.color((String)(enchantment.getColor() + enchantment.getCustomName() + " " + CrazyEnchantments.getInstance().convertLevelString(level))));
        }
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        Map enchants = CrazyEnchantments.getInstance().getEnchantments(mmoitem.getNBT().getItem());
        if (enchants.size() > 0) {
            mmoitem.setData(this, new CrazyEnchantsData(enchants));
        }
    }

    @Override
    @Nullable
    public RandomStatData<CrazyEnchantsData> whenInitialized(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        throw new NotImplementedException();
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        throw new NotImplementedException();
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomStatData<CrazyEnchantsData>> statData) {
        throw new NotImplementedException();
    }

    @Override
    @Nullable
    public CrazyEnchantsData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        return null;
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull CrazyEnchantsData data) {
        return new ArrayList<ItemTag>();
    }

    @Override
    public CrazyEnchantsData getClearStatData() {
        return new CrazyEnchantsData(new HashMap<CEnchantment, Integer>());
    }
}

