/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.denizen;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import java.util.Random;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.comp.denizen.SimpleTag;
import org.bukkit.OfflinePlayer;

public class MMOItemTemplateTag
extends SimpleTag {
    private final Type type;
    private final String id;
    private static final Random random = new Random();
    public static ObjectTagProcessor<MMOItemTemplateTag> tagProcessor = new ObjectTagProcessor();

    public MMOItemTemplateTag(Type type, String id) {
        this.type = type;
        this.id = id;
    }

    public MMOItemTemplate getTemplate() {
        return MMOItems.plugin.getTemplates().getTemplate(this.type, this.id);
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "MMOItemTemplate";
    }

    public String identify() {
        return "mmoitem_template@" + this.type.getId() + "." + this.id;
    }

    public String identifySimple() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public static void registerTags() {
        tagProcessor.registerTag("item_type", (attribute, object) -> new ElementTag(object.type.getName()), new String[0]);
        tagProcessor.registerTag("item_id", (attribute, object) -> new ElementTag(object.id), new String[0]);
        tagProcessor.registerTag("generate", (attribute, object) -> {
            ObjectTag matchLevelTag;
            if (!attribute.hasContext(1)) {
                return new ItemTag(object.getTemplate().newBuilder().build().newBuilder().build());
            }
            MapTag map = (MapTag)attribute.contextAsType(1, MapTag.class);
            if (map == null) {
                attribute.echoError("Invalid MapTag input");
                return null;
            }
            ObjectTag playerTag = map.getObject("player");
            if (playerTag != null && !(playerTag instanceof PlayerTag)) {
                attribute.echoError("Bad player input type");
                return null;
            }
            ObjectTag levelTag = map.getObject("level");
            int level = -1;
            if (levelTag != null) {
                try {
                    level = Integer.parseInt(levelTag.toString());
                }
                catch (IllegalArgumentException exception) {
                    attribute.echoError("Bad level input: " + levelTag + " is not a valid integer");
                    return null;
                }
            }
            boolean matchLevel = (matchLevelTag = map.getObject("match-level")) != null && Boolean.parseBoolean(matchLevelTag.toString());
            ObjectTag tierTag = map.getObject("tier");
            ItemTier tier = null;
            if (tierTag != null) {
                try {
                    tier = MMOItems.plugin.getTiers().getOrThrow(tierTag.toString().toUpperCase().replace("-", "_"));
                }
                catch (IllegalArgumentException exception) {
                    attribute.echoError(exception.getMessage());
                }
            }
            int itemLevel = level >= 0 ? level : (matchLevel && playerTag != null ? MMOItems.plugin.getTemplates().rollLevel(PlayerData.get((OfflinePlayer)((PlayerTag)playerTag).getPlayerEntity()).getRPG().getLevel()) : 1 + random.nextInt(100));
            ItemTier itemTier = tier != null ? tier : MMOItems.plugin.getTemplates().rollTier();
            return new ItemTag(object.getTemplate().newBuilder(itemLevel, itemTier).build().newBuilder().build());
        }, new String[0]);
    }

    public static MMOItemTemplateTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        try {
            String[] split = string.substring("mmoitem_template@".length()).split("\\.");
            String typeId = split[0];
            String itemId = split[1];
            Type type = MMOItems.plugin.getTypes().getOrThrow(typeId);
            MMOItems.plugin.getTemplates().getTemplateOrThrow(type, itemId);
            return new MMOItemTemplateTag(type, itemId);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

