/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.denizen;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.TagManager;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.comp.denizen.MMOItemTemplateTag;
import net.Indyuce.mmoitems.comp.denizen.MMOItemsItemProperty;

public class DenizenHook {
    public DenizenHook() {
        ObjectFetcher.registerWithObjectFetcher(MMOItemTemplateTag.class, MMOItemTemplateTag.tagProcessor);
        PropertyParser.registerProperty(MMOItemsItemProperty.class, ItemTag.class);
        TagManager.registerTagHandler((String)"mmoitem_template", attribute -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("Please provide an item type and ID.");
                return null;
            }
            MapTag map = (MapTag)attribute.contextAsType(1, MapTag.class);
            if (map == null) {
                attribute.echoError("Invalid MapTag input");
                return null;
            }
            ObjectTag type = map.getObject("type");
            ObjectTag id = map.getObject("id");
            if (type == null || id == null) {
                attribute.echoError("Invalid MapTag input - missing 'type' or 'id'");
                return null;
            }
            String typeName = type.toString().replace("-", "_").toUpperCase();
            Type parsedType = MMOItems.plugin.getTypes().get(typeName);
            if (parsedType == null) {
                attribute.echoError("Invalid type - cannot find type with name '" + typeName + "'");
                return null;
            }
            String formattedId = id.toString().replace("-", "_").toUpperCase();
            if (!MMOItems.plugin.getTemplates().hasTemplate(parsedType, formattedId)) {
                attribute.echoError("Invalid template ID - cannot find template with name '" + formattedId + "'");
                return null;
            }
            return new MMOItemTemplateTag(parsedType, formattedId);
        });
    }
}

