/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.command.mmoitems.update;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.PluginUpdate;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class InfoCommandTreeNode
extends CommandTreeNode {
    public InfoCommandTreeNode(CommandTreeNode parent) {
        super(parent, "info");
        this.addParameter(new Parameter("<id>", (explorer, list) -> MMOItems.plugin.getUpdates().getAll().forEach(update -> list.add("" + update.getId()))));
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        int id;
        if (args.length < 3) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        try {
            id = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException exception) {
            sender.sendMessage(ChatColor.RED + "Please specify a valid number.");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        if (!MMOItems.plugin.getUpdates().has(id)) {
            sender.sendMessage(ChatColor.RED + "Could not find any config update with ID " + id);
            return CommandTreeNode.CommandResult.FAILURE;
        }
        PluginUpdate update = MMOItems.plugin.getUpdates().get(id);
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "" + ChatColor.BOLD + "Config Update n" + update.getId());
        if (update.hasDescription()) {
            sender.sendMessage("");
            sender.sendMessage(ChatColor.DARK_GRAY + "Description:");
            for (String line : update.getDescription()) {
                sender.sendMessage(ChatColor.GRAY + "- " + ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
        }
        sender.sendMessage("");
        sender.sendMessage(ChatColor.YELLOW + "Use " + ChatColor.GOLD + "/mi update apply " + update.getId() + ChatColor.YELLOW + " to apply this config update.");
        return CommandTreeNode.CommandResult.SUCCESS;
    }
}

