/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.command.mmoitems;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import java.util.Random;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.command.MMOItemsCommandTreeRoot;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TakeCommandTreeNode
extends CommandTreeNode {
    private static final Random random = new Random();

    public TakeCommandTreeNode(CommandTreeNode parent) {
        super(parent, "take");
        this.addParameter(MMOItemsCommandTreeRoot.TYPE);
        this.addParameter(MMOItemsCommandTreeRoot.ID_2);
        this.addParameter(Parameter.PLAYER);
        this.addParameter(Parameter.AMOUNT);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        if (args.length != 5) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        try {
            Type type = MMOItems.plugin.getTypes().getOrThrow(args[1].toUpperCase().replace("-", "_"));
            String id = args[2].toUpperCase().replace("-", "_");
            Player target = Bukkit.getPlayer((String)args[3]);
            Validate.notNull((Object)target, (String)("Could not find player called '" + args[3] + "'."));
            int amountLeft = Integer.parseInt(args[4]);
            for (int i = 0; i < target.getInventory().getSize() && amountLeft > 0; ++i) {
                ItemStack item = target.getInventory().getItem(i);
                if (item == null || item.getType() == Material.AIR) continue;
                NBTItem nbtItem = NBTItem.get((ItemStack)item);
                String currentType = nbtItem.getType();
                if (!type.getId().equals(currentType) || !nbtItem.getString("MMOITEMS_ITEM_ID").equals(id)) continue;
                int removedAmount = Math.min(amountLeft, item.getAmount());
                amountLeft -= removedAmount;
                item.setAmount(item.getAmount() - removedAmount);
                target.getInventory().setItem(i, item);
            }
            return CommandTreeNode.CommandResult.SUCCESS;
        }
        catch (IllegalArgumentException exception) {
            sender.sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + exception.getMessage());
            return CommandTreeNode.CommandResult.FAILURE;
        }
    }
}

