/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.command.mmoitems;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.util.SmartGive;
import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.item.template.explorer.ClassFilter;
import net.Indyuce.mmoitems.api.item.template.explorer.IDFilter;
import net.Indyuce.mmoitems.api.item.template.explorer.TemplateExplorer;
import net.Indyuce.mmoitems.api.item.template.explorer.TierFilter;
import net.Indyuce.mmoitems.api.item.template.explorer.TypeFilter;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.command.mmoitems.GenerateCommandHandler;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GenerateCommandTreeNode
extends CommandTreeNode {
    private static final Random random = new Random();

    public GenerateCommandTreeNode(CommandTreeNode parent) {
        super(parent, "generate");
        this.addParameter(Parameter.PLAYER);
        this.addParameter(new Parameter("(extra-args)", (explorer, list) -> list.addAll(Arrays.asList("-matchlevel", "-matchclass", "-level:", "-class:", "-type:", "-id:", "-tier:", "-tierset:", "-gimme"))));
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        try {
            int itemLevel;
            if (args.length < 2) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            Validate.notNull((Object)target, (String)("Could not find player called " + args[1] + "."));
            GenerateCommandHandler handler = new GenerateCommandHandler(args);
            Player give = handler.hasArgument("gimme") || handler.hasArgument("giveme") ? (sender instanceof Player ? (Player)sender : null) : target;
            Validate.notNull((Object)give, (String)"You cannot use -gimme");
            RPGPlayer rpgPlayer = PlayerData.get((OfflinePlayer)target).getRPG();
            int n = handler.hasArgument("level:") ? Integer.parseInt(handler.getValue("level")) : (itemLevel = handler.hasArgument("matchlevel") ? MMOItems.plugin.getTemplates().rollLevel(rpgPlayer.getLevel()) : 1 + random.nextInt(100));
            ItemTier itemTier = handler.hasArgument("tierset") ? null : (handler.hasArgument("tier:") ? MMOItems.plugin.getTiers().getOrThrow(handler.getValue("tier").toUpperCase().replace("-", "_")) : MMOItems.plugin.getTemplates().rollTier());
            TemplateExplorer builder = new TemplateExplorer();
            if (handler.hasArgument("matchclass")) {
                builder.applyFilter(new ClassFilter(rpgPlayer));
            }
            if (handler.hasArgument("class:")) {
                builder.applyFilter(new ClassFilter(handler.getValue("class").replace("-", " ").replace("_", " ")));
            }
            String type = null;
            if (handler.hasArgument("tierset:")) {
                String format = UtilityMethods.enumName((String)handler.getValue("tierset"));
                Validate.isTrue((boolean)MMOItems.plugin.getTiers().has(format), (String)("Could not find tier with ID '" + format + "'"));
                builder.applyFilter(new TierFilter(format));
            }
            if (handler.hasArgument("type:")) {
                type = handler.getValue("type");
                Validate.isTrue((boolean)Type.isValid(type), (String)("Could not find type with ID '" + type + "'"));
                builder.applyFilter(new TypeFilter(Type.get(type)));
            }
            if (handler.hasArgument("id:")) {
                Validate.isTrue((type != null ? 1 : 0) != 0, (String)"You have to specify a type if using the id option!");
                builder.applyFilter(new IDFilter(handler.getValue("id")));
            }
            Optional<MMOItemTemplate> optional = builder.rollLoot();
            Validate.isTrue((boolean)optional.isPresent(), (String)"No item matched your criterias.");
            ItemStack item = optional.get().newBuilder(itemLevel, itemTier).build().newBuilder().build();
            Validate.isTrue((item != null && item.getType() != Material.AIR ? 1 : 0) != 0, (String)("Could not generate item with ID '" + optional.get().getId() + "'"));
            new SmartGive(give).give(new ItemStack[]{item});
            return CommandTreeNode.CommandResult.SUCCESS;
        }
        catch (IllegalArgumentException exception) {
            sender.sendMessage(ChatColor.RED + exception.getMessage());
            return CommandTreeNode.CommandResult.FAILURE;
        }
    }
}

