/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.util.message;

import io.lumine.mythic.lib.MythicLib;
import net.Indyuce.mmocore.api.player.PlayerActivity;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.util.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattedMessage {
    private final boolean actionBar;
    @NotNull
    private String message;

    public FormattedMessage(@NotNull Message message) {
        this.message = message.getRaw();
        this.actionBar = MMOItems.plugin.getConfig().getBoolean("action-bar-display." + message.getActionBarConfigPath());
    }

    public FormattedMessage(String message, boolean actionBar) {
        this.message = message;
        this.actionBar = actionBar;
    }

    @NotNull
    public FormattedMessage format(@Nullable ChatColor prefix, String ... toReplace) {
        if (this.message.isEmpty()) {
            return this;
        }
        if (prefix != null) {
            this.message = prefix + this.message;
        }
        for (int j = 0; j < toReplace.length; j += 2) {
            this.message = this.message.replace(toReplace[j], toReplace[j + 1]);
        }
        return this;
    }

    public void send(Player player) {
        if (this.message.isEmpty()) {
            return;
        }
        this.message = MythicLib.plugin.parseColors(this.message);
        if (this.actionBar) {
            if (Bukkit.getPluginManager().isPluginEnabled("MMOCore")) {
                PlayerData.get((OfflinePlayer)player).setLastActivity(PlayerActivity.ACTION_BAR_MESSAGE);
            }
            MythicLib.plugin.getVersion().getWrapper().sendActionBar(player, this.message);
        } else {
            player.sendMessage(this.message);
        }
    }

    public String toString() {
        return this.message;
    }
}

