/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.Indyuce.mmoitems.api.Type;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateMap<C> {
    private final Map<Type, Submap> typeMap = new HashMap<Type, Submap>();

    public boolean hasValue(@Nullable Type type, @Nullable String id) {
        if (type == null || id == null) {
            return false;
        }
        return this.typeMap.containsKey(type) && this.typeMap.get(type).idMap.containsKey(id);
    }

    @Nullable
    public C getValue(@Nullable Type type, @Nullable String id) {
        if (type == null || id == null) {
            return null;
        }
        Submap m = this.typeMap.get(type);
        if (m == null) {
            return null;
        }
        return (C)m.idMap.get(id);
    }

    public void removeValue(@Nullable Type type, @Nullable String id) {
        if (type == null || id == null) {
            return;
        }
        if (this.typeMap.containsKey(type)) {
            this.typeMap.get(type).idMap.remove(id);
        }
    }

    public void setValue(@NotNull Type type, @NotNull String id, @NotNull C value) {
        Validate.notNull(value, (String)"Value cannot be null");
        if (!this.typeMap.containsKey(type)) {
            this.typeMap.put(type, new Submap());
        }
        this.typeMap.get(type).idMap.put(id, value);
    }

    public void forEach(@NotNull Consumer<C> action) {
        this.typeMap.values().forEach((? super T submap) -> ((Submap)submap).idMap.values().forEach(action));
    }

    @NotNull
    public Collection<C> collectValues() {
        HashSet collected = new HashSet();
        this.typeMap.values().forEach((? super T submap) -> collected.addAll(((Submap)submap).idMap.values()));
        return collected;
    }

    @NotNull
    public Collection<C> collectValues(@NotNull Type type) {
        return this.typeMap.containsKey(type) ? this.typeMap.get(type).idMap.values() : new HashSet();
    }

    public void clear() {
        this.typeMap.clear();
    }

    private class Submap {
        private final Map<String, C> idMap = new LinkedHashMap();

        private Submap() {
        }
    }
}

