/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.util;

import java.text.DecimalFormat;
import java.util.Random;
import java.util.regex.Pattern;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.random.UpdatableRandomStatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class NumericStatFormula
implements RandomStatData<DoubleData>,
UpdatableRandomStatData<DoubleData> {
    private final double base;
    private final double scale;
    private final double spread;
    private final double maxSpread;
    private final double min;
    private final double max;
    private final boolean uniform;
    private final boolean hasMin;
    private final boolean hasMax;
    private static final Random RANDOM = new Random();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.####");
    public static final NumericStatFormula ZERO = new NumericStatFormula(0.0, 0.0, 0.0, 0.0);
    private static final double DEFAULT_MAX_SPREAD = 0.3;
    public static boolean RELATIVE_SPREAD = false;

    public NumericStatFormula(Object object) {
        Validate.notNull((Object)object, (String)"Config must not be null");
        if (object instanceof String) {
            if (object.toString().contains("->")) {
                String[] split = object.toString().replace(" ", "").split(Pattern.quote("->"));
                this.base = 0.0;
                this.scale = 0.0;
                this.spread = 0.0;
                this.maxSpread = 0.0;
                this.uniform = true;
                this.hasMin = true;
                this.hasMax = true;
                this.min = Double.parseDouble(split[0]);
                this.max = Double.parseDouble(split[1]);
            } else {
                String[] split = object.toString().split(" ");
                this.base = Double.parseDouble(split[0]);
                this.scale = split.length > 1 ? Double.parseDouble(split[1]) : 0.0;
                this.spread = split.length > 2 ? Double.parseDouble(split[2]) : 0.0;
                this.maxSpread = split.length > 3 ? Double.parseDouble(split[3]) : 0.0;
                this.hasMin = split.length > 4;
                this.hasMax = split.length > 5;
                this.min = this.hasMin ? Double.parseDouble(split[4]) : 0.0;
                this.max = this.hasMax ? Double.parseDouble(split[5]) : 0.0;
                this.uniform = false;
            }
        } else if (object instanceof Number) {
            this.base = Double.parseDouble(object.toString());
            this.scale = 0.0;
            this.spread = 0.0;
            this.maxSpread = 0.0;
            this.uniform = false;
            this.hasMin = false;
            this.hasMax = false;
            this.min = 0.0;
            this.max = 0.0;
        } else if (object instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)object;
            this.base = config.getDouble("base");
            this.scale = config.getDouble("scale");
            this.spread = config.getDouble("spread");
            this.maxSpread = config.getDouble("max-spread", 0.3);
            this.hasMin = config.contains("min");
            this.hasMax = config.contains("max");
            this.uniform = !config.contains("spread") && !config.contains("scale") && !config.contains("base") && this.hasMin && this.hasMax;
            this.min = this.hasMin ? config.getDouble("min") : 0.0;
            this.max = this.hasMax ? config.getDouble("max") : 0.0;
        } else {
            throw new IllegalArgumentException("Must specify a config section, a string or a number");
        }
        Validate.isTrue((this.spread >= 0.0 ? 1 : 0) != 0, (String)"Spread must be positive");
        Validate.isTrue((this.maxSpread >= 0.0 ? 1 : 0) != 0, (String)"Max spread must be positive");
    }

    public NumericStatFormula(double base, double scale, double spread, double maxSpread) {
        this(base, scale, spread, maxSpread, false, false, 0.0, false, 0.0);
    }

    public NumericStatFormula(double base, double scale, double spread, double min, double max) {
        this(base, scale, spread, 100.0, false, true, min, true, max);
    }

    public NumericStatFormula(double base, double scale, double spread, double maxSpread, boolean uniform, boolean hasMin, double min, boolean hasMax, double max) {
        this.base = base;
        this.scale = scale;
        this.spread = spread;
        this.maxSpread = maxSpread;
        this.uniform = uniform;
        this.hasMin = hasMin;
        this.hasMax = hasMax;
        this.min = min;
        this.max = max;
    }

    public double getBase() {
        return this.base;
    }

    public double getScale() {
        return this.scale;
    }

    public double getSpread() {
        return this.spread;
    }

    public double getMaxSpread() {
        return this.maxSpread;
    }

    public boolean isUniform() {
        return this.uniform;
    }

    public boolean hasMin() {
        return this.hasMin;
    }

    public boolean hasMax() {
        return this.hasMax;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double calculate(double scaleFactor) {
        return this.calculate(scaleFactor, FormulaInputType.RANDOM);
    }

    public double calculate(double scaleFactor, @NotNull FormulaInputType type) {
        return this.calculate(scaleFactor, type == FormulaInputType.RANDOM ? (this.uniform ? RANDOM.nextDouble() : RANDOM.nextGaussian()) : (type == FormulaInputType.UPPER_BOUND ? (this.uniform ? 1.0 : 2.5) : (type == FormulaInputType.LOWER_BOUND ? (this.uniform ? 0.0 : -2.5) : Double.NaN)));
    }

    public double calculate(double scaleFactor, double random) {
        double value;
        if (this.uniform) {
            return scaleFactor * this.scale + this.min + (this.max - this.min) * random;
        }
        double actualBase = this.base + this.scale * scaleFactor;
        double spreadCoef = Math.min(Math.max(random * this.spread, -this.maxSpread), this.maxSpread);
        double d = value = RELATIVE_SPREAD ? actualBase * (1.0 + spreadCoef) : actualBase + spreadCoef;
        if (this.hasMin) {
            value = Math.max(this.min, value);
        }
        if (this.hasMax) {
            value = Math.min(this.max, value);
        }
        return value;
    }

    @Override
    public DoubleData randomize(MMOItemBuilder builder) {
        return new DoubleData(this.calculate(builder.getLevel()));
    }

    public void fillConfigurationSection(@NotNull ConfigurationSection config, @NotNull String path, @NotNull FormulaSaveOption option) {
        if (path == null) {
            throw new NullPointerException("Path is empty");
        }
        if (this.scale == 0.0 && this.spread == 0.0 && this.maxSpread == 0.0 && !this.uniform) {
            config.set(path, this.base == 0.0 && option == FormulaSaveOption.DELETE_IF_ZERO ? null : Double.valueOf(this.base));
            return;
        }
        config.createSection(path);
        config = config.getConfigurationSection(path);
        if (!this.uniform) {
            config.set("base", (Object)this.base);
            config.set("scale", (Object)this.scale);
            config.set("spread", (Object)this.spread);
            config.set("max-spread", (Object)this.maxSpread);
        }
        if (this.hasMin) {
            config.set("min", (Object)this.min);
        }
        if (this.hasMax) {
            config.set("max", (Object)this.max);
        }
    }

    public void fillConfigurationSection(ConfigurationSection config, String path) {
        this.fillConfigurationSection(config, path, FormulaSaveOption.DELETE_IF_ZERO);
    }

    public String toString() {
        if (this.scale == 0.0 && this.spread == 0.0) {
            return DECIMAL_FORMAT.format(this.base);
        }
        if (this.scale == 0.0) {
            return "[" + DECIMAL_FORMAT.format(this.base * (1.0 - this.maxSpread)) + " -> " + DECIMAL_FORMAT.format(this.base * (1.0 + this.maxSpread)) + "] (" + DECIMAL_FORMAT.format(this.spread * 100.0) + "% Spread) (" + DECIMAL_FORMAT.format(this.base) + " Avg)";
        }
        return "{Base=" + DECIMAL_FORMAT.format(this.base) + (this.scale != 0.0 ? ",Scale=" + DECIMAL_FORMAT.format(this.scale) : "") + (this.spread != 0.0 ? ",Spread=" + this.spread : "") + (this.maxSpread != 0.0 ? ",Max=" + this.maxSpread : "") + "}";
    }

    @Override
    @NotNull
    public DoubleData reroll(@NotNull ItemStat stat, @NotNull DoubleData original, int determinedItemLevel) {
        double maxSD;
        double expectedValue = this.getBase() + this.getScale() * (double)determinedItemLevel;
        double previousValue = original.getValue();
        double shift = previousValue - expectedValue;
        double shiftSD = RELATIVE_SPREAD ? Math.abs(shift / (this.getSpread() * expectedValue)) : Math.abs(shift / this.getSpread());
        if (shiftSD > (maxSD = this.getMaxSpread() / this.getSpread()) || shiftSD > 3.5) {
            return new DoubleData(this.calculate(determinedItemLevel));
        }
        return original.clone();
    }

    public static enum FormulaInputType {
        UPPER_BOUND,
        LOWER_BOUND,
        RANDOM;

    }

    public static enum FormulaSaveOption {
        DELETE_IF_ZERO,
        NONE;

    }
}

