/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.util;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.interaction.util.DurabilityItem;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.inventory.EquippedItem;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.UpgradeData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeathDowngrading {
    private static final Random RANDOM = new Random();

    public static void playerDeathDowngrade(@NotNull Player player) {
        EquippedItem equip;
        PlayerData data = PlayerData.get((OfflinePlayer)player);
        double deathChance = data.getStats().getStat(ItemStats.DOWNGRADE_ON_DEATH_CHANCE);
        if (deathChance <= 0.0) {
            return;
        }
        data.updateInventory();
        List<EquippedItem> equipped = data.getInventory().getEquipped();
        Iterator<EquippedItem> ite = equipped.iterator();
        while (ite.hasNext()) {
            EquippedItem next = ite.next();
            if (next != null && DeathDowngrading.canDeathDowngrade(next.getCached())) continue;
            ite.remove();
        }
        if (equipped.size() == 0) {
            return;
        }
        while (deathChance >= 100.0 && equipped.size() > 0) {
            deathChance -= 100.0;
            int deathChosen = RANDOM.nextInt(equipped.size());
            equip = equipped.get(deathChosen);
            equip.setItem(DeathDowngrading.downgrade(new LiveMMOItem(equip.getNBT()), player));
            equipped.remove(deathChosen);
        }
        if (deathChance > 0.0 && equipped.size() > 0 && (double)RANDOM.nextInt(100) < deathChance) {
            int d = RANDOM.nextInt(equipped.size());
            equip = equipped.get(d);
            equip.setItem(DeathDowngrading.downgrade(new LiveMMOItem(equip.getNBT()), player));
            equipped.remove(d);
        }
    }

    @NotNull
    public static ArrayList<ItemStack> downgradeItems(@NotNull List<ItemStack> allItems, @NotNull Player player, double deathChance) {
        ItemStack equip;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ArrayList<ItemStack> downgrade = new ArrayList<ItemStack>();
        for (ItemStack item : allItems) {
            if (SilentNumbers.isAir((ItemStack)item)) continue;
            if (DeathDowngrading.canDeathDowngrade(item)) {
                downgrade.add(item);
                continue;
            }
            result.add(item);
        }
        while (deathChance >= 100.0 && downgrade.size() > 0) {
            deathChance -= 100.0;
            int deathChosen = RANDOM.nextInt(downgrade.size());
            equip = (ItemStack)downgrade.get(deathChosen);
            result.add(DeathDowngrading.downgrade(new LiveMMOItem(equip), player));
            downgrade.remove(deathChosen);
        }
        if (deathChance > 0.0 && downgrade.size() > 0 && (double)RANDOM.nextInt(100) < deathChance) {
            int deathChosen = RANDOM.nextInt(downgrade.size());
            equip = (ItemStack)downgrade.get(deathChosen);
            result.add(DeathDowngrading.downgrade(new LiveMMOItem(equip), player));
            downgrade.remove(deathChosen);
        }
        result.addAll(downgrade);
        return result;
    }

    @NotNull
    public static ItemStack downgrade(@NotNull ItemStack item, @NotNull Player player) {
        if (SilentNumbers.isAir((ItemStack)item) || !item.getType().isItem()) {
            return item;
        }
        NBTItem asNBT = NBTItem.get((ItemStack)item);
        if (!asNBT.hasType()) {
            return item;
        }
        return DeathDowngrading.downgrade(new LiveMMOItem(asNBT), player);
    }

    @NotNull
    public static ItemStack downgrade(@NotNull LiveMMOItem mmo, @NotNull Player player) {
        mmo.getUpgradeTemplate().upgradeTo(mmo, mmo.getUpgradeLevel() - 1);
        ItemStack bakedItem = mmo.newBuilder().build();
        DurabilityItem dur = new DurabilityItem(player, mmo.newBuilder().buildNBT());
        if (dur.getDurability() != dur.getMaxDurability()) {
            dur.addDurability(dur.getMaxDurability());
            bakedItem.setItemMeta(dur.toItem().getItemMeta());
        }
        Message.DEATH_DOWNGRADING.format(ChatColor.RED, "#item#", MMOUtils.getDisplayName(mmo.getNBT().getItem())).send(player);
        return bakedItem;
    }

    public static double getDeathDowngradeChance(@NotNull Player player) {
        PlayerData data = PlayerData.get((OfflinePlayer)player);
        return data.getStats().getStat(ItemStats.DOWNGRADE_ON_DEATH_CHANCE);
    }

    @Contract(value="null->false")
    public static boolean canDeathDowngrade(@Nullable ItemStack playerItem) {
        if (SilentNumbers.isAir((ItemStack)playerItem) || !playerItem.getType().isItem()) {
            return false;
        }
        NBTItem asNBT = NBTItem.get((ItemStack)playerItem);
        if (!asNBT.hasType()) {
            return false;
        }
        return DeathDowngrading.canDeathDowngrade(new VolatileMMOItem(asNBT));
    }

    @Contract(value="null->false")
    public static boolean canDeathDowngrade(@Nullable MMOItem playerItem) {
        if (playerItem == null) {
            return false;
        }
        if (!playerItem.hasData(ItemStats.DOWNGRADE_ON_DEATH)) {
            return false;
        }
        if (!playerItem.hasData(ItemStats.UPGRADE)) {
            return false;
        }
        if (!playerItem.hasUpgradeTemplate()) {
            return false;
        }
        UpgradeData upgradeData = (UpgradeData)playerItem.getData(ItemStats.UPGRADE);
        return upgradeData.getLevel() > upgradeData.getMin();
    }
}

