/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.player.inventory;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.util.Lazy;
import javax.annotation.Nullable;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import org.bukkit.inventory.ItemStack;

public abstract class EquippedItem {
    private final NBTItem item;
    private final EquipmentSlot slot;
    private final Lazy<VolatileMMOItem> cached;

    public EquippedItem(ItemStack item, EquipmentSlot slot) {
        this(NBTItem.get((ItemStack)item), slot);
    }

    public EquippedItem(NBTItem item, EquipmentSlot slot) {
        this.item = item;
        this.slot = slot;
        this.cached = Lazy.of(() -> new VolatileMMOItem(item));
    }

    public VolatileMMOItem getCached() {
        return (VolatileMMOItem)this.cached.get();
    }

    public NBTItem getNBT() {
        return this.item;
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public boolean isPlacementLegal() {
        String typeFormat = this.item.getString("MMOITEMS_ITEM_TYPE");
        if (typeFormat == null) {
            return false;
        }
        Type type = MMOItems.plugin.getTypes().get(typeFormat);
        if (type == null) {
            return false;
        }
        ModifierSource modSource = type.getModifierSource();
        return EquipmentSlot.OFF_HAND.isCompatible(modSource, this.slot) || EquipmentSlot.MAIN_HAND.isCompatible(modSource, this.slot);
    }

    public abstract void setItem(@Nullable ItemStack var1);
}

