/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.player;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class RPGPlayer {
    private final PlayerData playerData;
    private final Player player;

    @Deprecated
    public RPGPlayer(Player player) {
        this(PlayerData.get((OfflinePlayer)player));
    }

    public RPGPlayer(@NotNull PlayerData playerData) {
        this.player = playerData.getPlayer();
        this.playerData = playerData;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public Player getPlayer() {
        return this.playerData.getPlayer();
    }

    public abstract int getLevel();

    public abstract String getClassName();

    public abstract double getMana();

    public abstract double getStamina();

    public abstract void setMana(double var1);

    public abstract void setStamina(double var1);

    public void giveMana(double value) {
        this.setMana(this.getMana() + value);
    }

    public void giveStamina(double value) {
        this.setStamina(this.getStamina() + value);
    }

    public boolean canUse(NBTItem item, boolean message) {
        return this.canUse(item, message, false);
    }

    public boolean canUse(@NotNull NBTItem item, boolean message, boolean allowDynamic) {
        if (item.hasTag("MMOITEMS_UNIDENTIFIED_ITEM")) {
            if (message) {
                Message.UNIDENTIFIED_ITEM.format(ChatColor.RED, new String[0]).send(this.player.getPlayer());
                this.player.getPlayer().playSound(this.player.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.5f);
            }
            return false;
        }
        if (MMOItems.plugin.getLanguage().disableRemovedItems && MMOUtils.hasBeenRemoved(item)) {
            return false;
        }
        for (ItemRestriction condition : MMOItems.plugin.getStats().getItemRestrictionStats()) {
            if (condition.isDynamic() && allowDynamic || condition.canUse(this, item, message)) continue;
            return false;
        }
        return true;
    }
}

