/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.util.identify;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.util.AdventureUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.item.util.ConfigItem;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class UnidentifiedItem
extends ConfigItem {
    public UnidentifiedItem(Type type) {
        super("unidentified", type.getItem().getType());
        this.setName("#prefix#Unidentified " + type.getName());
        this.setLore(Arrays.asList("&7This item is unidentified. I must", "&7find a way to identify it!", "{tier}", "{tier}&8Item Info:", "{range}&8- &7Lvl Range: &e#range#", "{tier}&8- &7Item Tier: #prefix##tier#"));
    }

    public ItemBuilder newBuilder(NBTItem item) {
        return new ItemBuilder(item);
    }

    public class ItemBuilder {
        private final int amount;
        private final NBTItem item;
        private String name;
        private final List<String> lore;

        public ItemBuilder(NBTItem item) {
            this.name = UnidentifiedItem.this.getName();
            this.lore = new ArrayList<String>(UnidentifiedItem.this.getLore());
            this.amount = item.getItem().getAmount();
            this.item = item;
        }

        public ItemStack build() {
            VolatileMMOItem mmoitem = new VolatileMMOItem(this.item);
            ItemTier tier = ItemTier.ofItem(this.item);
            int level = ((MMOItem)mmoitem).hasData(ItemStats.REQUIRED_LEVEL) ? (int)((DoubleData)mmoitem.getData(ItemStats.REQUIRED_LEVEL)).getValue() : -1;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            if (tier != null) {
                placeholders.put("prefix", tier.getUnidentificationInfo().getPrefix());
                placeholders.put("tier", tier.getUnidentificationInfo().getDisplayName());
                if (level > -1) {
                    Object range = tier.getUnidentificationInfo().calculateRange(level);
                    placeholders.put("range", (int)range[0] + "-" + (int)range[1]);
                }
            } else {
                this.name = this.name.replace("#prefix#", "");
            }
            this.lore.removeIf(s -> s.startsWith("{tier}") && tier == null || s.startsWith("{range}") && (tier == null || level < 0));
            for (String placeholder : placeholders.keySet()) {
                this.name = this.name.replace("#" + placeholder + "#", (CharSequence)placeholders.get(placeholder));
            }
            for (int n = 0; n < this.lore.size(); ++n) {
                String str = this.lore.get(n);
                for (String placeholder : placeholders.keySet()) {
                    str = str.replace("#" + placeholder + "#", (CharSequence)placeholders.get(placeholder));
                }
                this.lore.set(n, MythicLib.plugin.parseColors(str.replace("{range}", "").replace("{tier}", "")));
            }
            this.item.getItem().setAmount(1);
            ItemStack unidentified = NBTItem.get((ItemStack)new ItemStack(UnidentifiedItem.this.material != null ? UnidentifiedItem.this.material : this.item.getItem().getType())).addTag(new ItemTag[]{new ItemTag("MMOITEMS_UNIDENTIFIED_ITEM", (Object)this.serialize(this.item.getItem()))}).toItem();
            ItemMeta meta = unidentified.getItemMeta();
            if (UnidentifiedItem.this.customModelData != null) {
                meta.setCustomModelData(UnidentifiedItem.this.customModelData);
            } else if (this.item.getItem().hasItemMeta() && this.item.getItem().getItemMeta().hasCustomModelData()) {
                meta.setCustomModelData(Integer.valueOf(this.item.getItem().getItemMeta().getCustomModelData()));
            }
            unidentified.setAmount(this.amount);
            meta.addItemFlags(ItemFlag.values());
            meta.setUnbreakable(true);
            AdventureUtils.setDisplayName((ItemMeta)meta, (String)this.name);
            AdventureUtils.setLore((ItemMeta)meta, this.lore);
            unidentified.setItemMeta(meta);
            return unidentified;
        }

        @NotNull
        private String serialize(ItemStack item) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
                dataOutput.writeObject((Object)item);
                dataOutput.close();
                return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

