/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.template;

import io.lumine.mythic.lib.UtilityMethods;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;

public class NameModifier {
    private final ModifierType type;
    private final String format;
    private final int priority;

    public NameModifier(ModifierType type, Object object) {
        Validate.notNull((Object)object, (String)"Object cannot be null");
        this.type = type;
        if (object instanceof String) {
            this.format = (String)object;
            this.priority = 0;
            return;
        }
        if (object instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)object;
            Validate.isTrue((boolean)config.contains("format"), (String)(UtilityMethods.caseOnWords((String)type.name().toLowerCase()) + " format cannot be null"));
            this.format = config.get("format").toString();
            this.priority = config.getInt("priority");
            return;
        }
        throw new IllegalArgumentException("Must specify a string or a config section");
    }

    public NameModifier(ModifierType type, String format, int priority) {
        Validate.notNull((Object)format, (String)"Format cannot be null");
        this.type = type;
        this.format = format;
        this.priority = priority;
        Validate.notNull((Object)((Object)type), (String)"Type cannot be null");
    }

    public String getFormat() {
        return this.format;
    }

    public ModifierType getType() {
        return this.type;
    }

    public boolean hasPriority() {
        return this.priority > 0;
    }

    public int getPriority() {
        return this.priority;
    }

    public static enum ModifierType {
        PREFIX,
        SUFFIX;

    }
}

