/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.template;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.util.PostLoadAction;
import io.lumine.mythic.lib.util.PreloadedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.item.template.NameModifier;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifierNode
implements PreloadedObject {
    private final String id;
    private final double chance;
    private final double weight;
    private final int min;
    private final int max;
    @Nullable
    private final NameModifier nameModifier;
    @Nullable
    private final List<ModifierNode> children;
    @Nullable
    private final Map<ItemStat, RandomStatData> data;
    private static final Random RANDOM = new Random();
    private final ModifierNode referenceNode;
    private final PostLoadAction postLoadAction = new PostLoadAction(config -> {
        ConfigurationSection modSection = config.getConfigurationSection("modifiers");
        if (modSection != null) {
            for (String key : modSection.getKeys(false)) {
                try {
                    ModifierNode child = ModifierNode.fromConfig(key, config.get("modifiers." + key));
                    child.getPostLoadAction().performAction();
                    this.children.add(child);
                }
                catch (RuntimeException exception) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load parent modifier node '" + key + "' of modifier group '" + this.getId() + "': " + exception.getMessage());
                }
            }
        }
        Validate.notNull(this.data, (String)"Internal error");
        ConfigurationSection statSection = config.getConfigurationSection("stats");
        if (statSection != null) {
            for (String key : statSection.getKeys(false)) {
                try {
                    String statId = UtilityMethods.enumName((String)key);
                    ItemStat<?, ?> stat = MMOItems.plugin.getStats().get(statId);
                    Validate.notNull(stat, (String)("Could not find stat with ID '" + statId + "'"));
                    this.data.put(stat, (RandomStatData)stat.whenInitialized(statSection.get(key)));
                }
                catch (IllegalArgumentException exception) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occurred while trying to load modifier node " + this.getId() + ": " + exception.getMessage());
                }
            }
        }
    });

    public ModifierNode(@NotNull String nodeId, @NotNull Object configObject) {
        ConfigurationSection config2;
        this.id = nodeId;
        if (configObject instanceof Number) {
            this.referenceNode = ModifierNode.findReferenceNode(this.id);
            this.chance = this.referenceNode.chance;
            this.weight = ((Number)configObject).doubleValue();
            this.nameModifier = this.referenceNode.nameModifier;
        } else if (configObject instanceof String) {
            this.referenceNode = ModifierNode.findReferenceNode(configObject.toString());
            this.chance = this.referenceNode.chance;
            this.weight = this.referenceNode.weight;
            this.nameModifier = this.referenceNode.nameModifier;
        } else if (configObject instanceof ConfigurationSection) {
            config2 = (ConfigurationSection)configObject;
            ModifierNode referenceNode = null;
            try {
                referenceNode = ModifierNode.findReferenceNode(this.id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.referenceNode = referenceNode;
            this.chance = config2.getDouble("chance", referenceNode != null ? referenceNode.getChance() : 1.0);
            this.weight = config2.getDouble("weight", referenceNode != null ? referenceNode.getWeight() : 0.0);
            this.nameModifier = config2.contains("suffix") ? new NameModifier(NameModifier.ModifierType.SUFFIX, config2.get("suffix")) : (config2.contains("prefix") ? new NameModifier(NameModifier.ModifierType.PREFIX, config2.get("prefix")) : (referenceNode != null ? referenceNode.nameModifier : null));
            Validate.isTrue((this.chance > 0.0 ? 1 : 0) != 0, (String)"Chance must be strictly positive");
        } else {
            throw new IllegalArgumentException("Must be either a string, number config section");
        }
        if (this.referenceNode != null) {
            this.children = this.referenceNode.children;
            config2 = configObject instanceof ConfigurationSection ? (ConfigurationSection)configObject : null;
            this.min = config2 != null && config2.contains("min") ? config2.getInt("min") : this.referenceNode.min;
            this.max = config2 != null && config2.contains("max") ? config2.getInt("max") : this.referenceNode.max;
            this.data = this.referenceNode.data;
        } else {
            Validate.isTrue((boolean)(configObject instanceof ConfigurationSection), (String)"Must provide a config section when not using a reference node");
            config2 = (ConfigurationSection)configObject;
            this.min = config2.getInt("min");
            this.max = config2.getInt("max", -1);
            this.children = new ArrayList<ModifierNode>();
            this.postLoadAction.cacheConfig(config2);
            this.data = new HashMap<ItemStat, RandomStatData>();
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getChance() {
        return this.chance;
    }

    @NotNull
    public Map<ItemStat, RandomStatData> getItemData() {
        return this.data;
    }

    @Nullable
    public ModifierNode getReferenceNode() {
        return this.referenceNode;
    }

    @Nullable
    public NameModifier getNameModifier() {
        return this.nameModifier;
    }

    public boolean hasNameModifier() {
        return this.nameModifier != null;
    }

    public boolean rollChance() {
        return RANDOM.nextDouble() < this.chance;
    }

    public PostLoadAction getPostLoadAction() {
        return this.postLoadAction;
    }

    public List<ModifierNode> getChildren() {
        return this.children;
    }

    public boolean collect(@NotNull MMOItemBuilder builder) {
        if (!this.rollChance()) {
            return false;
        }
        if (this.weight > builder.getCapacity()) {
            return false;
        }
        UUID modifierId = UUID.randomUUID();
        builder.reduceCapacity(this.weight);
        if (this.hasNameModifier()) {
            builder.addModifier(this.getNameModifier(), modifierId);
        }
        this.whenCollected(builder, modifierId);
        return true;
    }

    public void whenCollected(@NotNull MMOItemBuilder builder, @NotNull UUID modifierId) {
        this.data.forEach((itemStat, statData) -> builder.addModifierData((ItemStat)itemStat, (StatData)statData.randomize(builder), modifierId));
        ArrayList<ModifierNode> children = new ArrayList<ModifierNode>(this.children);
        if (builder.getTemplate().hasOption(MMOItemTemplate.TemplateOption.ROLL_MODIFIER_CHECK_ORDER)) {
            Collections.shuffle(children);
        }
        int effectiveMax = this.max <= 0 ? children.size() : Math.min(this.max, children.size());
        int i = 0;
        while (this.children.size() - children.size() < effectiveMax && i < children.size()) {
            ModifierNode next = (ModifierNode)children.get(i);
            if (next.collect(builder)) {
                children.remove(i);
                continue;
            }
            ++i;
        }
        while (this.children.size() - children.size() < this.min) {
            ModifierNode node = (ModifierNode)children.remove(this.rollModifier(children));
            node.collect(builder);
        }
    }

    @NotNull
    public static ModifierNode fromConfig(@NotNull String nodeId, @NotNull Object configObject) {
        if (configObject instanceof Number || configObject instanceof String) {
            Validate.notNull((Object)ModifierNode.findReferenceNode(nodeId), (String)("Could not find reference node called '" + nodeId + "'"));
        }
        return new ModifierNode(nodeId, configObject);
    }

    @NotNull
    private static ModifierNode findReferenceNode(@NotNull String id) {
        ModifierNode node = MMOItems.plugin.getTemplates().getModifierNode(id);
        Validate.notNull((Object)node, (String)("Could not find public modifier with ID '" + id + "'"));
        return node;
    }

    @NotNull
    private int rollModifier(@NotNull List<ModifierNode> children) {
        double[] cumulatedWeights = new double[children.size()];
        double totalWeight = 0.0;
        for (int i = 0; i < children.size(); ++i) {
            cumulatedWeights[i] = totalWeight += children.get(i).getChance();
        }
        double random = RANDOM.nextDouble() * totalWeight;
        for (int i = 0; i < children.size(); ++i) {
            if (!(random <= cumulatedWeights[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not roll new modifier from group '" + this.getId() + "'");
    }
}

