/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.mmoitem;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.UpgradeTemplate;
import net.Indyuce.mmoitems.api.item.ItemReference;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.util.MMOItemReforger;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.GemSocketsData;
import net.Indyuce.mmoitems.stat.data.GemstoneData;
import net.Indyuce.mmoitems.stat.data.MaterialData;
import net.Indyuce.mmoitems.stat.data.UpgradeData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import net.Indyuce.mmoitems.tooltip.TooltipTexture;
import net.Indyuce.mmoitems.util.Pair;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItem
implements ItemReference {
    private final Type type;
    private final String id;
    @NotNull
    private final Map<ItemStat, StatData> stats = new HashMap<ItemStat, StatData>();
    @NotNull
    private final Map<ItemStat<?, ?>, StatHistory> mergeableStatHistory = new HashMap();

    public MMOItem(Type type, String id) {
        this.type = type;
        this.id = id;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void mergeData(@NotNull ItemStat stat, @NotNull StatData data, @Nullable UUID associatedGemStone) {
        if (data instanceof Mergeable) {
            StatHistory sHistory = this.computeStatHistory(stat);
            if (associatedGemStone != null) {
                sHistory.registerGemstoneData(associatedGemStone, data);
            } else {
                sHistory.registerExternalData(data);
            }
            this.setData(stat, sHistory.recalculate(this.getUpgradeLevel()));
        } else {
            this.setData(stat, data);
        }
    }

    public void setData(@NotNull ItemStat stat, @NotNull StatData data) {
        this.stats.put(stat, data);
    }

    public void replaceData(@NotNull ItemStat stat, @NotNull StatData data) {
        this.stats.replace(stat, data);
    }

    public void removeData(@NotNull ItemStat stat) {
        this.stats.remove(stat);
    }

    @Nullable
    public StatData getData(@NotNull ItemStat stat) {
        return this.stats.get(stat);
    }

    @NotNull
    public StatData computeData(@NotNull ItemStat<?, ?> stat) {
        return this.stats.computeIfAbsent(stat, ItemStat::getClearStatData);
    }

    public boolean hasData(@NotNull ItemStat stat) {
        return this.stats.get(stat) != null;
    }

    @NotNull
    public Set<ItemStat> getStats() {
        return this.stats.keySet();
    }

    @NotNull
    public ItemStackBuilder newBuilder() {
        return new ItemStackBuilder(this);
    }

    public MMOItem clone() {
        MMOItem clone = new MMOItem(this.type, this.id);
        clone.stats.putAll(this.stats);
        this.mergeableStatHistory.forEach((stat, hist) -> clone.mergeableStatHistory.put((ItemStat<?, ?>)stat, hist.clone().setParent(clone)));
        return clone;
    }

    public boolean hasStatHistory(@NotNull ItemStat<?, ?> stat) {
        return stat instanceof Mergeable && this.mergeableStatHistory.containsKey(stat);
    }

    @Nullable
    public StatHistory getStatHistory(@NotNull ItemStat<?, ?> stat) {
        if (stat.equals(ItemStats.ENCHANTS)) {
            return this.computeStatHistory(stat);
        }
        return this.mergeableStatHistory.get(stat);
    }

    @NotNull
    public StatHistory computeStatHistory(@NotNull ItemStat<?, ?> stat) {
        return this.mergeableStatHistory.computeIfAbsent(stat, itemStat -> {
            StatData currentData = this.computeData((ItemStat<?, ?>)itemStat);
            Validate.isTrue((boolean)(currentData instanceof Mergeable), (String)("Stat " + itemStat.getId() + " is not mergeable"));
            return new StatHistory(this, (ItemStat)itemStat, currentData);
        });
    }

    @NotNull
    public ArrayList<StatHistory> getStatHistories() {
        return new ArrayList<StatHistory>(this.mergeableStatHistory.values());
    }

    public void setStatHistory(@NotNull ItemStat stat, @NotNull StatHistory hist) {
        this.mergeableStatHistory.put(stat, hist);
    }

    @Nullable
    public ItemTier getTier() {
        StatData found = this.stats.get(ItemStats.TIER);
        return found != null ? MMOItems.plugin.getTiers().get(found.toString()) : null;
    }

    @Nullable
    public TooltipTexture getTooltip() {
        StatData found = this.stats.get(ItemStats.TOOLTIP);
        return found != null ? MMOItems.plugin.getLore().getTooltip(found.toString()) : null;
    }

    @Deprecated
    public int getDamage() {
        int maxDurability;
        int n = maxDurability = this.hasData(ItemStats.MAX_DURABILITY) ? SilentNumbers.round((double)((DoubleData)this.getData(ItemStats.MAX_DURABILITY)).getValue()) : -1;
        if (maxDurability > 0) {
            NBTItem nbtItem = this.newBuilder().buildNBT();
            int durability = this.hasData(ItemStats.CUSTOM_DURABILITY) ? SilentNumbers.round((double)((DoubleData)this.getData(ItemStats.CUSTOM_DURABILITY)).getValue()) : maxDurability;
            return maxDurability - durability;
        }
        return this.hasData(ItemStats.ITEM_DAMAGE) ? SilentNumbers.round((double)((DoubleData)this.getData(ItemStats.ITEM_DAMAGE)).getValue()) : 0;
    }

    @Deprecated
    public void setDamage(int damage) {
        int maxDurability;
        if (this.hasData(ItemStats.UNBREAKABLE)) {
            return;
        }
        int n = maxDurability = this.hasData(ItemStats.MAX_DURABILITY) ? SilentNumbers.round((double)((DoubleData)this.getData(ItemStats.MAX_DURABILITY)).getValue()) : -1;
        if (maxDurability > 0) {
            NBTItem nbtItem = this.newBuilder().buildNBT();
            this.setData(ItemStats.CUSTOM_DURABILITY, new DoubleData(maxDurability - damage));
            Material mat = this.hasData(ItemStats.MATERIAL) ? ((MaterialData)this.getData(ItemStats.MATERIAL)).getMaterial() : Material.GOLD_INGOT;
            double multiplier = (double)damage * (double)mat.getMaxDurability() / (double)maxDurability;
            if (multiplier == 0.0) {
                return;
            }
            this.setData(ItemStats.ITEM_DAMAGE, new DoubleData(multiplier));
        } else {
            this.setData(ItemStats.ITEM_DAMAGE, new DoubleData(damage));
        }
    }

    public void upgrade() {
        this.getUpgradeTemplate().upgrade(this);
    }

    public boolean hasUpgradeTemplate() {
        return this.hasData(ItemStats.UPGRADE) && ((UpgradeData)this.getData(ItemStats.UPGRADE)).getTemplate() != null;
    }

    public int getUpgradeLevel() {
        return this.hasData(ItemStats.UPGRADE) ? ((UpgradeData)this.getData(ItemStats.UPGRADE)).getLevel() : 0;
    }

    public int getMaxUpgradeLevel() {
        if (this.hasData(ItemStats.UPGRADE)) {
            return ((UpgradeData)this.getData(ItemStats.UPGRADE)).getMax();
        }
        return 0;
    }

    @NotNull
    public UpgradeTemplate getUpgradeTemplate() {
        Validate.isTrue((boolean)this.hasUpgradeTemplate(), (String)"Item has no upgrade information");
        UpgradeData data = (UpgradeData)this.getData(ItemStats.UPGRADE);
        return data.getTemplate();
    }

    @NotNull
    public List<GemstoneData> getGemstones() {
        StatData data = this.getData(ItemStats.GEM_SOCKETS);
        return data == null ? new ArrayList() : ((GemSocketsData)data).getGems();
    }

    @Deprecated
    public Set<GemstoneData> getGemStones() {
        return new HashSet<GemstoneData>(this.getGemstones());
    }

    @NotNull
    public List<Pair<GemstoneData, MMOItem>> extractGemstones() {
        GemSocketsData thisSocketsData = (GemSocketsData)this.getData(ItemStats.GEM_SOCKETS);
        if (thisSocketsData == null) {
            return new ArrayList<Pair<GemstoneData, MMOItem>>();
        }
        ArrayList<Pair<GemstoneData, MMOItem>> pairs = new ArrayList<Pair<GemstoneData, MMOItem>>();
        for (GemstoneData gem : thisSocketsData.getGemstones()) {
            MMOItem restored = MMOItems.plugin.getMMOItem(MMOItems.plugin.getTypes().get(gem.getMMOItemType()), gem.getMMOItemID());
            if (restored == null) continue;
            pairs.add(Pair.of(gem, restored));
        }
        if (MMOItemReforger.gemstonesRevIDWhenUnsocket) {
            return pairs;
        }
        for (StatHistory hist : this.mergeableStatHistory.values()) {
            for (Pair pair : pairs) {
                StatData historicGemData = hist.getGemstoneData(((GemstoneData)pair.getKey()).getHistoricUUID());
                if (historicGemData == null) continue;
                ((MMOItem)pair.getValue()).setData(hist.getItemStat(), historicGemData);
            }
        }
        return pairs;
    }

    @Nullable
    public MMOItem extractGemstone(@NotNull GemstoneData gem) {
        MMOItem restored = MMOItems.plugin.getMMOItem(MMOItems.plugin.getTypes().get(gem.getMMOItemType()), gem.getMMOItemID());
        if (restored == null) {
            return null;
        }
        if (MMOItemReforger.gemstonesRevIDWhenUnsocket) {
            return restored;
        }
        for (StatHistory hist : this.mergeableStatHistory.values()) {
            StatData historicGemData = hist.getGemstoneData(gem.getHistoricUUID());
            if (historicGemData == null) continue;
            restored.setData(hist.getItemStat(), historicGemData);
        }
        return restored;
    }

    public void removeGemStone(@NotNull UUID gemUUID, @Nullable String color) {
        if (!this.hasData(ItemStats.GEM_SOCKETS)) {
            return;
        }
        StatHistory gemStory = this.computeStatHistory(ItemStats.GEM_SOCKETS);
        if (((GemSocketsData)gemStory.getOriginalData()).removeGem(gemUUID, color)) {
            return;
        }
        for (UUID gemDataUUID : gemStory.getAllGemstones()) {
            if (!((GemSocketsData)gemStory.getGemstoneData(gemDataUUID)).removeGem(gemUUID, color)) continue;
            return;
        }
        for (StatData externalData : gemStory.getExternalData()) {
            if (!((GemSocketsData)externalData).removeGem(gemUUID, color)) continue;
            return;
        }
        for (UUID gemDataUUID : gemStory.getAllModifiers()) {
            if (!((GemSocketsData)gemStory.getModifiersBonus(gemDataUUID)).removeGem(gemUUID, color)) continue;
            return;
        }
    }
}

