/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.item.template.ModifierNode;
import net.Indyuce.mmoitems.api.item.template.NameModifier;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.NameData;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import net.Indyuce.mmoitems.util.Buildable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItemBuilder
extends Buildable<MMOItem> {
    private final MMOItemTemplate template;
    private final MMOItem mmoitem;
    private final int level;
    private final ItemTier tier;
    private double capacity;
    private final Map<UUID, NameModifier> nameModifiers = new HashMap<UUID, NameModifier>();

    public MMOItemBuilder(MMOItemTemplate template, int level, @Nullable ItemTier tier) {
        this(template, level, tier, false);
    }

    public MMOItemBuilder(@NotNull MMOItemTemplate template, int level, @Nullable ItemTier tier, boolean forDisplay) {
        this.template = template;
        this.level = level;
        this.tier = tier;
        ItemTier itemTier = tier != null ? tier : (tier = template.getBaseItemData().containsKey(ItemStats.TIER) ? MMOItems.plugin.getTiers().get(template.getBaseItemData().get(ItemStats.TIER).toString()) : null);
        this.capacity = (template.hasModifierCapacity() ? template.getModifierCapacity() : (tier != null && tier.hasCapacity() ? tier.getModifierCapacity() : MMOItems.plugin.getLanguage().defaultItemCapacity)).calculate(level);
        this.mmoitem = new MMOItem(template.getType(), template.getId());
        template.getBaseItemData().forEach((stat, random) -> this.applyData((ItemStat)stat, (StatData)random.randomize(this)));
        if (tier != null) {
            this.mmoitem.setData(ItemStats.TIER, new StringData(tier.getId()));
        }
        if (level > 0) {
            this.mmoitem.setData(ItemStats.ITEM_LEVEL, new DoubleData(level));
        }
        if (tier != null && tier.getTooltip() != null && !this.mmoitem.hasData(ItemStats.TOOLTIP)) {
            this.mmoitem.setData(ItemStats.TOOLTIP, new StringData(tier.getTooltip().getId()));
        }
        if (!forDisplay && template.hasModifierGroup()) {
            template.getModifierGroup().collect(this);
        }
    }

    @NotNull
    public MMOItemTemplate getTemplate() {
        return this.template;
    }

    public int getLevel() {
        return this.level;
    }

    @Nullable
    public ItemTier getTier() {
        return this.tier;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void reduceCapacity(double weight) {
        this.capacity -= weight;
    }

    @Override
    protected MMOItem whenBuilt() {
        if (!this.nameModifiers.isEmpty()) {
            StatHistory hist = this.mmoitem.computeStatHistory(ItemStats.NAME);
            this.nameModifiers.forEach((obs, mod) -> {
                NameData modName = new NameData(null);
                if (mod.getType() == NameModifier.ModifierType.PREFIX) {
                    modName.addPrefix(mod.getFormat());
                } else if (mod.getType() == NameModifier.ModifierType.SUFFIX) {
                    modName.addSuffix(mod.getFormat());
                }
                hist.registerModifierBonus((UUID)obs, modName);
            });
            this.mmoitem.setData(ItemStats.NAME, hist.recalculate(this.mmoitem.getUpgradeLevel()));
        }
        return this.mmoitem;
    }

    public void applyData(@NotNull ItemStat stat, @NotNull StatData data) {
        StatData found = this.mmoitem.getData(stat);
        if (found != null && found instanceof Mergeable) {
            ((Mergeable)found).mergeWith((Mergeable)data);
        } else {
            this.mmoitem.setData(stat, data);
        }
    }

    public void addModifierData(@NotNull ItemStat stat, @NotNull StatData data, @NotNull UUID uuid) {
        if (stat.getClearStatData() instanceof Mergeable) {
            this.mmoitem.computeStatHistory(stat).registerModifierBonus(uuid, data);
        } else {
            this.mmoitem.setData(stat, data);
        }
    }

    public void addModifier(@NotNull NameModifier modifier, @NotNull UUID modifierId) {
        Iterator<NameModifier> ite = this.nameModifiers.values().iterator();
        while (ite.hasNext()) {
            NameModifier obs = ite.next();
            if (obs.getType() != modifier.getType()) continue;
            if (obs.getPriority() > modifier.getPriority()) {
                return;
            }
            if (obs.getPriority() >= modifier.getPriority()) continue;
            ite.remove();
        }
        this.nameModifiers.put(modifierId, modifier);
    }

    @Deprecated
    @NotNull
    public static Collection<ModifierNode> rollModifiers(@NotNull MMOItemTemplate template) {
        if (!template.hasOption(MMOItemTemplate.TemplateOption.ROLL_MODIFIER_CHECK_ORDER)) {
            return template.getModifiers().values();
        }
        ArrayList<ModifierNode> modifiers = new ArrayList<ModifierNode>(template.getModifiers().values());
        Collections.shuffle(modifiers);
        return modifiers;
    }

    @Override
    @NotNull
    public MMOItem build() {
        return (MMOItem)super.build();
    }
}

