/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.interaction.weapon;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.comp.flags.CustomFlag;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.cooldown.CooldownObject;
import io.lumine.mythic.lib.skill.SimpleSkill;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.SkillResult;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import javax.annotation.Nullable;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.UntargetedWeaponUseEvent;
import net.Indyuce.mmoitems.api.interaction.UseItem;
import net.Indyuce.mmoitems.api.interaction.WeaponAttackResult;
import net.Indyuce.mmoitems.api.interaction.util.UntargetedDurabilityItem;
import net.Indyuce.mmoitems.api.interaction.weapon.untargeted.LegacyWeapon;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class Weapon
extends UseItem {
    @Deprecated
    public Weapon(Player player, NBTItem item) {
        this(PlayerData.get((OfflinePlayer)player), item);
    }

    public Weapon(PlayerData playerData, NBTItem item) {
        super(playerData, item);
    }

    @Override
    public boolean checkItemRequirements() {
        if (this.playerData.isEncumbered()) {
            Message.HANDS_TOO_CHARGED.format(ChatColor.RED, new String[0]).send(this.getPlayer());
            return false;
        }
        return this.playerData.getRPG().canUse(this.getNBTItem(), true) && MythicLib.plugin.getFlags().isFlagAllowed(this.getPlayer(), this.getUseFlag());
    }

    public CustomFlag getUseFlag() {
        return CustomFlag.MI_WEAPONS;
    }

    public boolean checkAndApplyWeaponCosts() {
        if (!this.checkWeaponCosts(false)) {
            return false;
        }
        this.applyWeaponCosts(null);
        return true;
    }

    public boolean checkWeaponCosts(boolean cooldowns) {
        if (cooldowns && this.getPlayerData().getMMOPlayerData().getCooldownMap().isOnCooldown((CooldownObject)this.mmoitem.getType())) {
            return false;
        }
        double manaCost = this.getNBTItem().getStat("MANA_COST");
        if (manaCost > 0.0 && this.playerData.getRPG().getMana() < manaCost) {
            Message.NOT_ENOUGH_MANA.format(ChatColor.RED, new String[0]).send(this.getPlayer());
            return false;
        }
        double staminaCost = this.getNBTItem().getStat("STAMINA_COST");
        if (staminaCost > 0.0 && this.playerData.getRPG().getStamina() < staminaCost) {
            Message.NOT_ENOUGH_STAMINA.format(ChatColor.RED, new String[0]).send(this.getPlayer());
            return false;
        }
        return true;
    }

    public void applyWeaponCosts(@Nullable Double attackDelay) {
        double staminaCost;
        double manaCost = this.getNBTItem().getStat("MANA_COST");
        if (manaCost > 0.0) {
            this.playerData.getRPG().giveMana(-manaCost);
        }
        if ((staminaCost = this.getNBTItem().getStat("STAMINA_COST")) > 0.0) {
            this.playerData.getRPG().giveStamina(-staminaCost);
        }
        if (attackDelay != null) {
            this.getPlayerData().getMMOPlayerData().getCooldownMap().applyCooldown((CooldownObject)this.mmoitem.getType(), attackDelay.doubleValue());
        }
    }

    public boolean handleTargetedAttack(AttackMetadata attackMeta, @NotNull PlayerMetadata attacker, LivingEntity target) {
        if (!this.checkAndApplyWeaponCosts()) {
            return false;
        }
        SkillHandler<?> onHitSkill = this.mmoitem.getType().onAttack();
        if (onHitSkill != null && !this.getNBTItem().getBoolean("MMOITEMS_DISABLE_ATTACK_PASSIVE")) {
            new SimpleSkill(onHitSkill).cast(new TriggerMetadata(attacker, TriggerType.API, (Entity)target, attackMeta));
        }
        return true;
    }

    @Nullable
    private SkillHandler findClickSkill(boolean rightClick) {
        String skillId = this.getNBTItem().getString((rightClick ? ItemStats.RIGHT_CLICK_SCRIPT : ItemStats.LEFT_CLICK_SCRIPT).getNBTPath());
        if (!rightClick && (skillId == null || skillId.isEmpty())) {
            skillId = this.getNBTItem().getString("MMOITEMS_STAFF_SPIRIT");
        }
        if (skillId == null || skillId.isEmpty()) {
            Type itemType = this.mmoitem.getType();
            return rightClick ? itemType.onRightClick() : itemType.onLeftClick();
        }
        return MythicLib.plugin.getSkills().getHandler(skillId);
    }

    @Nullable
    public WeaponAttackResult handleUntargetedAttack(boolean rightClick, @NotNull EquipmentSlot actionHand) {
        if (this instanceof LegacyWeapon) {
            return this.legacyHandleUntargetedAttack(rightClick, actionHand);
        }
        SkillHandler handler = this.findClickSkill(rightClick);
        if (handler == null) {
            return WeaponAttackResult.NO_ATTACK;
        }
        SkillMetadata meta = new TriggerMetadata(this.getPlayerData().getMMOPlayerData(), TriggerType.API).toSkillMetadata((Skill)new SimpleSkill(handler));
        SkillResult result = handler.getResult(meta);
        if (!result.isSuccessful()) {
            return WeaponAttackResult.NO_ATTACK;
        }
        UntargetedDurabilityItem durItem = new UntargetedDurabilityItem(this.getPlayer(), this.getNBTItem(), actionHand);
        if (durItem.isBroken()) {
            return WeaponAttackResult.DURABILITY;
        }
        PlayerMetadata stats = this.getPlayerData().getStats().newTemporary(actionHand);
        if (!this.checkWeaponCosts(true)) {
            return WeaponAttackResult.WEAPON_COSTS;
        }
        UntargetedWeaponUseEvent called = new UntargetedWeaponUseEvent(this.playerData, this);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            return WeaponAttackResult.BUKKIT_EVENT;
        }
        double attackDelay = 1.0 / this.requireNonZero(stats.getStat("ATTACK_SPEED"), MMOItems.plugin.getConfig().getDouble("default.attack-speed"));
        this.applyWeaponCosts(attackDelay);
        handler.whenCast(result, meta);
        if (durItem.isValid()) {
            durItem.decreaseDurability(1).inventoryUpdate();
        }
        return WeaponAttackResult.SUCCESS;
    }

    @Deprecated
    private WeaponAttackResult legacyHandleUntargetedAttack(boolean rightClick, @NotNull EquipmentSlot actionHand) {
        if (!((LegacyWeapon)((Object)this)).canAttack(rightClick, actionHand)) {
            return WeaponAttackResult.NO_ATTACK;
        }
        UntargetedDurabilityItem durItem = new UntargetedDurabilityItem(this.getPlayer(), this.getNBTItem(), actionHand);
        if (durItem.isBroken()) {
            return WeaponAttackResult.DURABILITY;
        }
        PlayerMetadata stats = this.getPlayerData().getStats().newTemporary(actionHand);
        if (!this.checkWeaponCosts(true)) {
            return WeaponAttackResult.WEAPON_COSTS;
        }
        UntargetedWeaponUseEvent called = new UntargetedWeaponUseEvent(this.playerData, this);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            return WeaponAttackResult.BUKKIT_EVENT;
        }
        double attackDelay = 1.0 / this.requireNonZero(stats.getStat("ATTACK_SPEED"), MMOItems.plugin.getConfig().getDouble("default.attack-speed"));
        this.applyWeaponCosts(attackDelay);
        PlayerMetadata caster = this.playerData.getMMOPlayerData().getStatMap().cache(actionHand);
        ((LegacyWeapon)((Object)this)).applyAttackEffect(caster, actionHand);
        if (durItem.isValid()) {
            durItem.decreaseDurability(1).inventoryUpdate();
        }
        return WeaponAttackResult.SUCCESS;
    }

    @Deprecated
    protected Location getGround(Location loc) {
        for (int j = 0; j < 20; ++j) {
            if (loc.getBlock().getType().isSolid()) {
                return loc;
            }
            loc.add(0.0, -1.0, 0.0);
        }
        return loc;
    }

    protected double requireNonZero(double number, double elseNumber) {
        return number <= 0.0 ? elseNumber : number;
    }
}

