/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.interaction;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.SmartGive;
import io.lumine.mythic.lib.comp.flags.CustomFlag;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.ConsumableConsumedEvent;
import net.Indyuce.mmoitems.api.interaction.UseItem;
import net.Indyuce.mmoitems.api.item.util.LoreUpdate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.stat.type.PlayerConsumable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Consumable
extends UseItem {
    @Deprecated
    public Consumable(Player player, NBTItem item) {
        super(player, item);
    }

    public Consumable(PlayerData player, NBTItem item) {
        super(player, item);
    }

    @Override
    public boolean checkItemRequirements() {
        return MythicLib.plugin.getFlags().isFlagAllowed(this.player, CustomFlag.MI_CONSUMABLES) && this.playerData.getRPG().canUse(this.getNBTItem(), true);
    }

    public boolean useOnItem(@NotNull InventoryClickEvent event, @NotNull NBTItem target) {
        if (event.getClickedInventory() != event.getWhoClicked().getInventory()) {
            return false;
        }
        Type targetType = MMOItems.getType(target);
        for (ConsumableItemInteraction action : MMOItems.plugin.getStats().getConsumableActions()) {
            if (!action.handleConsumableEffect(event, this.playerData, this, target, targetType)) continue;
            return true;
        }
        return false;
    }

    public ConsumableConsumeResult useOnPlayer(EquipmentSlot handUsed, boolean vanillaEeating) {
        NBTItem nbtItem = this.getNBTItem();
        if (nbtItem.getBoolean(ItemStats.INEDIBLE.getNBTPath())) {
            return ConsumableConsumeResult.CANCEL;
        }
        ConsumableConsumedEvent event = new ConsumableConsumedEvent(this.playerData, this.mmoitem, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return ConsumableConsumeResult.CANCEL;
        }
        for (PlayerConsumable sc : MMOItems.plugin.getStats().getPlayerConsumables()) {
            sc.onConsume(this.mmoitem, this.player, vanillaEeating);
        }
        int usesLeft = nbtItem.getInteger(ItemStats.MAX_CONSUME.getNBTPath());
        if (usesLeft > 1) {
            nbtItem.addTag(new ItemTag[]{new ItemTag(ItemStats.MAX_CONSUME.getNBTPath(), (Object)(--usesLeft))});
            String format = MythicLib.inst().parseColors(ItemStats.MAX_CONSUME.getGeneralStatFormat());
            String old = format.replace("{value}", String.valueOf(usesLeft + 1));
            String replaced = format.replace("{value}", String.valueOf(usesLeft));
            ItemStack newItem = new LoreUpdate(nbtItem.toItem(), old, replaced).updateLore();
            ItemStack oldItem = nbtItem.getItem();
            if (oldItem.getAmount() > 1) {
                newItem.setAmount(1);
                this.player.getInventory().setItem(handUsed, newItem);
                oldItem.setAmount(oldItem.getAmount() - 1);
                new SmartGive(this.player).give(new ItemStack[]{oldItem});
            } else {
                this.player.getInventory().setItem(handUsed, newItem);
            }
            return ConsumableConsumeResult.NOT_CONSUME;
        }
        return !event.isConsumed() || nbtItem.getBoolean(ItemStats.DISABLE_RIGHT_CLICK_CONSUME.getNBTPath()) ? ConsumableConsumeResult.NOT_CONSUME : ConsumableConsumeResult.CONSUME;
    }

    public boolean hasVanillaEating() {
        return (this.getItem().getType().isEdible() || this.getItem().getType() == Material.POTION || this.getItem().getType() == Material.MILK_BUCKET) && this.getNBTItem().hasTag("MMOITEMS_VANILLA_EATING");
    }

    public static enum ConsumableConsumeResult {
        CANCEL,
        CONSUME,
        NOT_CONSUME;

    }
}

