/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.edition.input;

import net.Indyuce.mmoitems.api.edition.Edition;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerInputHandler {
    private final Edition edition;

    public PlayerInputHandler(Edition edition) {
        this.edition = edition;
    }

    public Player getPlayer() {
        return this.edition.getInventory().getPlayer();
    }

    protected void registerInput(@NotNull String input) {
        Validate.isTrue((boolean)Bukkit.isPrimaryThread(), (String)"Input must be registered on primary thread");
        if (input.equalsIgnoreCase("cancel") || this.edition.processInput(input)) {
            if (this.edition.shouldGoBack()) {
                this.edition.getInventory().open();
            }
            this.close();
        }
    }

    public abstract void close();
}

