/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.droptable.item;

import java.util.Random;
import javax.annotation.Nullable;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.bukkit.inventory.ItemStack;

public abstract class DropItem {
    private final double drop;
    private final int min;
    private final int max;
    protected static final Random random = new Random();

    public DropItem(double drop, int min, int max) {
        this.drop = drop;
        this.min = min;
        this.max = max;
    }

    public DropItem(String str) {
        String[] argSplit = str.split(",");
        this.drop = Double.parseDouble(argSplit[0]) / 100.0;
        String[] amountSplit = argSplit[1].split("-");
        this.min = Integer.parseInt(amountSplit[0]);
        this.max = amountSplit.length > 1 ? Integer.parseInt(amountSplit[1]) : this.min;
    }

    public boolean rollDrop() {
        return random.nextDouble() < this.drop;
    }

    public int rollAmount() {
        return this.max > this.min ? this.min + random.nextInt(this.max - this.min + 1) : this.min;
    }

    public ItemStack getItem(@Nullable PlayerData player) {
        return this.getItem(player, this.rollAmount());
    }

    public abstract ItemStack getItem(@Nullable PlayerData var1, int var2);

    public abstract String getKey();
}

