/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.droptable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.droptable.item.BlockDropItem;
import net.Indyuce.mmoitems.api.droptable.item.DropItem;
import net.Indyuce.mmoitems.api.droptable.item.MMOItemDropItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class DropTable {
    private final List<String> subtablesList = new ArrayList<String>();
    private final Map<String, Subtable> subtables = new HashMap<String, Subtable>();
    private static final Random random = new Random();

    public DropTable(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Could not read the drop table config");
        for (String key : config.getKeys(false)) {
            try {
                for (int j = 0; j < config.getInt(key + ".coef"); ++j) {
                    this.subtablesList.add(key);
                }
                this.subtables.put(key, new Subtable(config.getConfigurationSection(key)));
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not read subtable '" + key + "' from drop table '" + config.getName() + "': " + exception.getMessage());
            }
        }
        Validate.notEmpty(this.subtablesList, (String)"Your droptable must contain at least one subtable");
    }

    public String getRandomSubtable() {
        return this.subtablesList.get(random.nextInt(this.subtablesList.size()));
    }

    public List<ItemStack> read(@Nullable PlayerData player, boolean silkTouch) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        String randomSubtable = this.getRandomSubtable();
        for (DropItem dropItem : this.getSubtable(randomSubtable).getDropItems(silkTouch)) {
            if (!dropItem.rollDrop()) continue;
            ItemStack drop = dropItem.getItem(player);
            if (drop == null) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Couldn't read the subtable item " + dropItem.getKey());
                continue;
            }
            dropped.add(drop);
        }
        return dropped;
    }

    public Collection<Subtable> getSubtables() {
        return this.subtables.values();
    }

    public Subtable getSubtable(String key) {
        return this.subtables.get(key);
    }

    public static class Subtable {
        private final List<DropItem> items = new ArrayList<DropItem>();
        private final boolean disableSilkTouch;

        public Subtable(ConfigurationSection subtable) {
            Validate.notNull((Object)subtable, (String)"Could not read subtable config");
            Validate.isTrue((boolean)subtable.contains("coef"), (String)"Could not read subtable coefficient.");
            Validate.isTrue((subtable.contains("items") || subtable.contains("blocks") ? 1 : 0) != 0, (String)"Could not find item/block list");
            if (subtable.contains("items")) {
                for (String typeFormat : subtable.getConfigurationSection("items").getKeys(false)) {
                    Type type = MMOItems.plugin.getTypes().getOrThrow(typeFormat.toUpperCase().replace("-", "_"));
                    for (String id : subtable.getConfigurationSection("items." + typeFormat).getKeys(false)) {
                        this.items.add(new MMOItemDropItem(type, id, subtable.getString("items." + typeFormat + "." + id)));
                    }
                }
            }
            if (subtable.contains("blocks")) {
                for (String idFormat : subtable.getConfigurationSection("blocks").getKeys(false)) {
                    int id = Integer.parseInt(idFormat);
                    Validate.isTrue((id > 0 && id != 54 && id <= 160 ? 1 : 0) != 0, (String)(id + " is not a valid block ID"));
                    this.items.add(new BlockDropItem(id, subtable.getString("blocks." + idFormat)));
                }
            }
            this.disableSilkTouch = subtable.getBoolean("disable-silk-touch");
        }

        public List<DropItem> getDropItems(boolean silkTouch) {
            return silkTouch && this.disableSilkTouch ? new ArrayList() : this.items;
        }
    }
}

