/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.recipe;

import io.lumine.mythic.lib.api.MMOLineConfig;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.CraftingStation;
import net.Indyuce.mmoitems.api.crafting.condition.Condition;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.IngredientInventory;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.trigger.Trigger;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public abstract class Recipe {
    private final String id;
    private final Map<RecipeOption, Boolean> options = new HashMap<RecipeOption, Boolean>();
    private final Set<Ingredient> ingredients = new LinkedHashSet<Ingredient>();
    private final Set<Condition> conditions = new LinkedHashSet<Condition>();
    private final Set<Trigger> onUse = new LinkedHashSet<Trigger>();
    private final Set<Trigger> onClaim = new LinkedHashSet<Trigger>();
    private final Set<Trigger> onCancel = new LinkedHashSet<Trigger>();

    public Recipe(ConfigurationSection config) {
        this(config.getName());
        if (config.contains("options")) {
            for (RecipeOption option : RecipeOption.values()) {
                if (!config.getConfigurationSection("options").contains(option.getConfigPath())) continue;
                this.options.put(option, config.getBoolean("options." + option.getConfigPath()));
            }
        }
        for (String format : config.getStringList("ingredients")) {
            try {
                Ingredient ingredient = MMOItems.plugin.getCrafting().getIngredient(new MMOLineConfig(format));
                this.ingredients.add(ingredient);
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalArgumentException("Could not load ingredient '" + format + "': " + exception.getMessage());
            }
        }
        for (String format : config.getStringList("conditions")) {
            try {
                Condition condition = MMOItems.plugin.getCrafting().getCondition(new MMOLineConfig(format));
                this.conditions.add(condition);
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalArgumentException("Could not load condition '" + format + "': " + exception.getMessage());
            }
        }
        if (this.conditions.isEmpty() && this.ingredients.isEmpty()) {
            throw new IllegalArgumentException("No conditions or ingredients set.");
        }
        this.loadTriggerList(config.getStringList("on-use"), "on-use", this.onUse);
        this.loadTriggerList(config.getStringList("triggers"), "on-claim", this.onClaim);
        this.loadTriggerList(config.getStringList("on-cancel"), "on-cancel", this.onCancel);
    }

    private void loadTriggerList(List<String> stringList, String triggerType, Set<Trigger> collection) {
        for (String format : stringList) {
            try {
                Trigger trigger = MMOItems.plugin.getCrafting().getTrigger(new MMOLineConfig(format));
                Validate.notNull((Object)trigger, (String)"Could not match trigger");
                collection.add(trigger);
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalArgumentException("Could not load " + triggerType + " trigger '" + format + "': " + exception.getMessage());
            }
        }
    }

    private Recipe(String id) {
        Validate.notNull((Object)id, (String)"Recipe ID must not be null");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Set<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Set<Condition> getConditions() {
        return this.conditions;
    }

    public Set<Trigger> whenUsed() {
        return this.onUse;
    }

    public Set<Trigger> whenClaimed() {
        return this.onClaim;
    }

    public Set<Trigger> whenCanceled() {
        return this.onCancel;
    }

    public Condition getCondition(String format) {
        for (Condition condition : this.conditions) {
            if (!condition.getId().equals(format)) continue;
            return condition;
        }
        return null;
    }

    public boolean hasOption(RecipeOption option) {
        return this.options.getOrDefault((Object)option, option.getDefault());
    }

    public void addIngredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
    }

    public void registerCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void setOption(RecipeOption option, boolean value) {
        this.options.put(option, value);
    }

    public abstract CheckedRecipe evaluateRecipe(PlayerData var1, IngredientInventory var2);

    public abstract boolean whenUsed(PlayerData var1, IngredientInventory var2, CheckedRecipe var3, CraftingStation var4);

    public abstract boolean canUse(PlayerData var1, IngredientInventory var2, CheckedRecipe var3, CraftingStation var4);

    public abstract ItemStack display(CheckedRecipe var1);

    public boolean equals(Object obj) {
        return obj instanceof Recipe && ((Recipe)obj).id.equals(this.id);
    }

    public static enum RecipeOption {
        HIDE_WHEN_LOCKED(false),
        HIDE_WHEN_NO_INGREDIENTS(false),
        OUTPUT_ITEM(true),
        SILENT_CRAFT(false);

        private final boolean def;

        private RecipeOption(boolean def) {
            this.def = def;
        }

        public boolean getDefault() {
            return this.def;
        }

        public String getConfigPath() {
            return this.name().toLowerCase().replace("_", "-");
        }
    }
}

