/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.recipe;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicBlueprintInventory;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeInventory;
import io.lumine.mythic.lib.api.crafting.ingredients.ShapedIngredient;
import io.lumine.mythic.lib.api.crafting.outputs.MRORecipe;
import io.lumine.mythic.lib.api.crafting.outputs.MythicRecipeOutput;
import io.lumine.mythic.lib.api.crafting.recipes.MythicCachedResult;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.vmp.VanillaInventoryMapping;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.recipe.SmithingCombinationType;
import net.Indyuce.mmoitems.api.interaction.GemStone;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.stat.Enchants;
import net.Indyuce.mmoitems.stat.data.EnchantListData;
import net.Indyuce.mmoitems.stat.data.GemSocketsData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSmithingRecipe
extends MythicRecipeOutput {
    @Nullable
    MythicRecipe mainInputConsumption;
    @Nullable
    MythicRecipe ingotInputConsumption;
    int outputAmount;
    @NotNull
    final MMOItemTemplate outputItem;
    final boolean dropGemstones;
    @NotNull
    final SmithingCombinationType enchantmentTreatment;
    @NotNull
    final SmithingCombinationType upgradeTreatment;

    public CustomSmithingRecipe(@NotNull MMOItemTemplate outputItem, boolean dropGemstones, @NotNull SmithingCombinationType enchantmentTreatment, @NotNull SmithingCombinationType upgradeTreatment, int outputAmount) {
        this.outputItem = outputItem;
        this.dropGemstones = dropGemstones;
        this.enchantmentTreatment = enchantmentTreatment;
        this.upgradeTreatment = upgradeTreatment;
        this.outputAmount = outputAmount;
    }

    @Nullable
    public MythicRecipe getMainInputConsumption() {
        return this.mainInputConsumption;
    }

    public void setMainInputConsumption(@Nullable MythicRecipe mic) {
        this.mainInputConsumption = this.nullifyIfEmpty(mic);
    }

    public boolean hasInputConsumption() {
        return this.ingotInputConsumption != null || this.mainInputConsumption != null;
    }

    @Nullable
    public MythicRecipe nullifyIfEmpty(@Nullable MythicRecipe mic) {
        if (mic == null) {
            return null;
        }
        for (MythicRecipeIngredient mri : mic.getIngredients()) {
            if (mri == null || !mri.getIngredient().isDefinesItem()) continue;
            return mic;
        }
        return null;
    }

    @Nullable
    public MythicRecipe getIngotInputConsumption() {
        return this.ingotInputConsumption;
    }

    public void setIngotInputConsumption(@Nullable MythicRecipe mic) {
        this.ingotInputConsumption = this.nullifyIfEmpty(mic);
    }

    @NotNull
    MythicRecipeInventory generateResultOf(@NotNull MythicRecipe mythicRecipe) {
        HashMap<Integer, ItemStack[]> rowsInformation = new HashMap<Integer, ItemStack[]>();
        for (MythicRecipeIngredient mmIngredient : mythicRecipe.getIngredients()) {
            if (mmIngredient == null) continue;
            ShapedIngredient shaped = (ShapedIngredient)mmIngredient;
            MythicIngredient ingredient = mmIngredient.getIngredient();
            if (!ingredient.isDefinesItem()) continue;
            FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
            ffp.activatePrefix(true, "Recipe of " + this.getOutputItem().getType().getId() + " " + this.getOutputItem().getId());
            ItemStack gen = mmIngredient.getIngredient().getRandomSubstituteItem(ffp);
            if (gen != null) {
                ItemStack[] row = (ItemStack[])rowsInformation.get(-shaped.getVerticalOffset());
                if (row == null) {
                    row = new ItemStack[shaped.getHorizontalOffset() + 1];
                }
                if (row.length < shaped.getHorizontalOffset() + 1) {
                    ItemStack[] newRow = new ItemStack[shaped.getHorizontalOffset() + 1];
                    for (int r = 0; r < row.length; ++r) {
                        newRow[r] = row[r];
                    }
                    row = newRow;
                }
                row[shaped.getHorizontalOffset()] = gen;
                rowsInformation.put(-shaped.getVerticalOffset(), row);
                continue;
            }
            ffp.sendTo(FriendlyFeedbackCategory.ERROR, MythicLib.plugin.getServer().getConsoleSender());
        }
        MythicRecipeInventory ret = new MythicRecipeInventory();
        for (Integer h : rowsInformation.keySet()) {
            ret.setRow(h.intValue(), (ItemStack[])rowsInformation.get(h));
        }
        return ret;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public void setOutputAmount(int amount) {
        this.outputAmount = amount;
    }

    @NotNull
    public MMOItemTemplate getOutputItem() {
        return this.outputItem;
    }

    @NotNull
    public SmithingCombinationType getEnchantmentTreatment() {
        return this.enchantmentTreatment;
    }

    public boolean isDropGemstones() {
        return this.dropGemstones;
    }

    @NotNull
    public SmithingCombinationType getUpgradeTreatment() {
        return this.upgradeTreatment;
    }

    @Nullable
    MMOItem fromStack(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        NBTItem itemNBT = NBTItem.get((ItemStack)item);
        if (MMOItems.getType(itemNBT) != null) {
            return new LiveMMOItem(item);
        }
        return null;
    }

    @Nullable
    ItemStack firstFromFirstSide(@NotNull MythicBlueprintInventory b) {
        if (b.getSideInventoryNames().size() == 0) {
            return null;
        }
        return b.getSideInventory((String)b.getSideInventoryNames().get(0)).getFirst();
    }

    @NotNull
    public MythicRecipeInventory applyDisplay(@NotNull MythicBlueprintInventory mythicRecipeInventory, @NotNull InventoryClickEvent eventTrigger, @NotNull VanillaInventoryMapping mapping) {
        if (!(eventTrigger.getWhoClicked() instanceof Player)) {
            return mythicRecipeInventory.getResultInventory();
        }
        MythicBlueprintInventory original = mapping.extractFrom(VersionUtils.getView((InventoryEvent)eventTrigger).getTopInventory());
        ItemStack item = original.getMainInventory().getFirst();
        ItemStack ingot = this.firstFromFirstSide(original);
        MMOItem display = this.fromCombinationWith(item, ingot, (Player)eventTrigger.getWhoClicked(), null);
        MythicRecipeInventory result = mythicRecipeInventory.getResultInventory().clone();
        result.setItemAt(mapping.getResultWidth(mapping.getResultInventoryStart()), mapping.getResultHeight(mapping.getResultInventoryStart()), display.newBuilder().build());
        return result;
    }

    public void applyResult(@NotNull MythicRecipeInventory resultInventory, @NotNull MythicBlueprintInventory otherInventories, @NotNull MythicCachedResult cache, @NotNull InventoryClickEvent eventTrigger, @NotNull VanillaInventoryMapping map, int times) {
        eventTrigger.setCancelled(true);
        if (!(eventTrigger.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)eventTrigger.getWhoClicked();
        ItemStack item = otherInventories.getMainInventory().getFirst();
        ItemStack ingot = this.firstFromFirstSide(otherInventories);
        Ref droppedGemstones = new Ref();
        MMOItem display = this.fromCombinationWith(item, ingot, player, (Ref<ArrayList<ItemStack>>)droppedGemstones);
        if (times == 1 && eventTrigger.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            MythicRecipeInventory result = otherInventories.getResultInventory().clone();
            result.setItemAt(map.getResultWidth(map.getResultInventoryStart()), map.getResultHeight(map.getResultInventoryStart()), display.newBuilder().build());
            ItemStack currentInCursor = eventTrigger.getCursor();
            this.processInventory(resultInventory, result, 1);
            ItemStack cursor = resultInventory.getItemAt(map.getResultWidth(eventTrigger.getSlot()), map.getResultHeight(eventTrigger.getSlot()));
            if (cursor == null) {
                cursor = new ItemStack(Material.AIR);
            }
            ItemStack actualCursor = cursor.clone();
            if (!SilentNumbers.isAir((ItemStack)currentInCursor)) {
                if (currentInCursor.isSimilar(actualCursor)) {
                    int maxAmount;
                    int aAmount;
                    int cAmount = currentInCursor.getAmount();
                    if (cAmount + (aAmount = actualCursor.getAmount()) > (maxAmount = actualCursor.getMaxStackSize())) {
                        return;
                    }
                    actualCursor.setAmount(cAmount + aAmount);
                } else {
                    return;
                }
            }
            cursor.setAmount(0);
            map.applyToResultInventory(eventTrigger.getInventory(), resultInventory, false);
            VersionUtils.getView((InventoryEvent)eventTrigger).setCursor(actualCursor);
            this.consumeIngredients(otherInventories, cache, eventTrigger.getInventory(), map, 1);
            if (this.hasInputConsumption()) {
                ArrayList inputConsumptionOverflow = new ArrayList();
                if (this.getMainInputConsumption() != null) {
                    MythicRecipeInventory mainRead = map.getMainMythicInventory(eventTrigger.getInventory());
                    MythicRecipeInventory addedStuff = this.generateResultOf(this.getMainInputConsumption());
                    inputConsumptionOverflow.addAll(MRORecipe.stackWhatsPossible((MythicRecipeInventory)mainRead, (MythicRecipeInventory)addedStuff));
                    map.applyToMainInventory(eventTrigger.getInventory(), mainRead, false);
                }
                if (this.getIngotInputConsumption() != null) {
                    MythicRecipeInventory sideRead = map.getSideMythicInventory("ingot", eventTrigger.getInventory());
                    MythicRecipeInventory addedStuff = this.generateResultOf(this.getIngotInputConsumption());
                    inputConsumptionOverflow.addAll(MRORecipe.stackWhatsPossible((MythicRecipeInventory)sideRead, (MythicRecipeInventory)addedStuff));
                    map.applyToSideInventory(eventTrigger.getInventory(), sideRead, "ingot", false);
                }
                MRORecipe.distributeInInventoryOrDrop((Inventory)eventTrigger.getWhoClicked().getInventory(), inputConsumptionOverflow, (Location)eventTrigger.getWhoClicked().getLocation());
            }
        } else {
            HashMap modifiedInventory = null;
            PlayerInventory inven = player.getInventory();
            int trueTimes = 0;
            int t = 1;
            while (t <= times) {
                HashMap localIterationResult;
                MythicRecipeInventory result = otherInventories.getResultInventory().clone();
                result.setItemAt(map.getResultWidth(map.getResultInventoryStart()), map.getResultHeight(map.getResultInventoryStart()), display.newBuilder().build());
                ArrayList localOutput = MRORecipe.toItemsList((MythicRecipeInventory)result);
                if (this.hasInputConsumption()) {
                    MythicRecipeInventory addedStuff;
                    if (this.getMainInputConsumption() != null) {
                        addedStuff = this.generateResultOf(this.getMainInputConsumption());
                        localOutput.addAll(MRORecipe.toItemsList((MythicRecipeInventory)addedStuff));
                    }
                    if (this.getIngotInputConsumption() != null) {
                        addedStuff = this.generateResultOf(this.getIngotInputConsumption());
                        localOutput.addAll(MRORecipe.toItemsList((MythicRecipeInventory)addedStuff));
                    }
                }
                if ((localIterationResult = MRORecipe.distributeInInventory((Inventory)inven, (ArrayList)localOutput, (HashMap)modifiedInventory)) == null) break;
                modifiedInventory = localIterationResult;
                trueTimes = t++;
            }
            if (trueTimes == 0) {
                return;
            }
            times = trueTimes;
            for (Integer s : modifiedInventory.keySet()) {
                ItemStack putt = (ItemStack)modifiedInventory.get(s);
                inven.setItem(s.intValue(), putt);
            }
            this.consumeIngredients(otherInventories, cache, eventTrigger.getInventory(), map, times);
        }
        if (this.isDropGemstones() && droppedGemstones.getValue() != null && player.getLocation().getWorld() != null) {
            for (ItemStack drop : player.getInventory().addItem(((ArrayList)droppedGemstones.getValue()).toArray(new ItemStack[0])).values()) {
                if (SilentNumbers.isAir((ItemStack)drop)) continue;
                player.getWorld().dropItem(player.getLocation(), drop);
            }
        }
    }

    @NotNull
    MMOItem fromCombinationWith(@Nullable ItemStack itemStack, @Nullable ItemStack ingotStack, @NotNull Player p, @Nullable Ref<ArrayList<ItemStack>> rem) {
        MMOItem item = this.fromStack(itemStack);
        MMOItem ingot = this.fromStack(ingotStack);
        MMOItem gen = this.getOutputItem().newBuilder(0, null).build();
        ArrayList compGemstones = new ArrayList();
        if (item != null) {
            item.extractGemstones().forEach(pair -> compGemstones.add((MMOItem)pair.getValue()));
        }
        if (ingot != null) {
            ingot.extractGemstones().forEach(pair -> compGemstones.add((MMOItem)pair.getValue()));
        }
        ArrayList<ItemStack> remainingStones = new ArrayList<ItemStack>();
        for (MMOItem m : compGemstones) {
            GemSocketsData genGemstones = (GemSocketsData)gen.getData(ItemStats.GEM_SOCKETS);
            if (genGemstones == null || genGemstones.getEmptySlots().size() == 0) {
                remainingStones.add(m.newBuilder().build());
                continue;
            }
            GemStone asGem = new GemStone(PlayerData.get((OfflinePlayer)p), m.newBuilder().buildNBT());
            GemStone.ApplyResult res = asGem.applyOntoItem(gen, gen.getType(), "", false, true);
            if (res.getType() == GemStone.ResultType.SUCCESS && res.getResultAsMMOItem() != null) {
                gen = res.getResultAsMMOItem();
                continue;
            }
            remainingStones.add(m.newBuilder().build());
        }
        Ref.setValue(rem, remainingStones);
        if (this.getEnchantmentTreatment() != SmithingCombinationType.NONE) {
            EnchantListData genEnchants = (EnchantListData)gen.getData(ItemStats.ENCHANTS);
            if (genEnchants == null) {
                genEnchants = (EnchantListData)ItemStats.ENCHANTS.getClearStatData();
            }
            EnchantListData itemEnchants = item != null ? (EnchantListData)item.getData(ItemStats.ENCHANTS) : Enchants.fromVanilla(itemStack);
            EnchantListData ingotEnchants = ingot != null ? (EnchantListData)ingot.getData(ItemStats.ENCHANTS) : Enchants.fromVanilla(ingotStack);
            for (Enchantment observedEnchantment : Enchantment.values()) {
                int finalLevel;
                int genLevel = genEnchants.getLevel(observedEnchantment);
                int itemLevel = itemEnchants.getLevel(observedEnchantment);
                int ingotLevel = ingotEnchants.getLevel(observedEnchantment);
                switch (this.getEnchantmentTreatment()) {
                    case ADDITIVE: {
                        finalLevel = itemLevel + ingotLevel + genLevel;
                        break;
                    }
                    case MAXIMUM: {
                        if (genLevel == 0) {
                            genLevel = itemLevel;
                        }
                        finalLevel = Math.max(genLevel, Math.max(itemLevel, ingotLevel));
                        break;
                    }
                    case MINIMUM: {
                        if (genLevel == 0) {
                            genLevel = itemLevel;
                        }
                        finalLevel = Math.max(genLevel, Math.min(itemLevel, ingotLevel));
                        break;
                    }
                    default: {
                        finalLevel = genLevel == 0 ? SilentNumbers.ceil((double)((double)(itemLevel + ingotLevel) / 2.0)) : SilentNumbers.ceil((double)((double)(itemLevel + ingotLevel + genLevel) / 3.0));
                    }
                }
                genEnchants.addEnchant(observedEnchantment, finalLevel);
            }
            gen.setData(ItemStats.ENCHANTS, genEnchants);
        }
        if (gen.hasUpgradeTemplate() && this.getUpgradeTreatment() != SmithingCombinationType.NONE) {
            int finalLevel;
            int itemLevel = 0;
            if (item != null) {
                itemLevel = item.getUpgradeLevel();
            }
            int ingotLevel = 0;
            if (ingot != null) {
                ingotLevel = ingot.getUpgradeLevel();
            }
            switch (this.getUpgradeTreatment()) {
                case ADDITIVE: {
                    finalLevel = itemLevel + ingotLevel;
                    break;
                }
                case MAXIMUM: {
                    finalLevel = Math.max(itemLevel, ingotLevel);
                    break;
                }
                case MINIMUM: {
                    finalLevel = Math.min(itemLevel, ingotLevel);
                    break;
                }
                default: {
                    finalLevel = SilentNumbers.ceil((double)((double)(itemLevel + ingotLevel) / 2.0));
                }
            }
            gen.getUpgradeTemplate().upgradeTo(gen, Math.min(finalLevel, gen.getMaxUpgradeLevel()));
        }
        return gen;
    }
}

