/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.ingredient.inventory;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.ingredient.CheckedIngredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.IngredientType;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.PlayerIngredient;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IngredientInventory {
    private final Map<String, List<PlayerIngredient>> ingredients = new HashMap<String, List<PlayerIngredient>>();

    public IngredientInventory(Player player) {
        this((Inventory)player.getInventory());
    }

    public IngredientInventory(Inventory inv) {
        block0: for (ItemStack item : inv.getContents()) {
            if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) continue;
            NBTItem nbt = MythicLib.plugin.getVersion().getWrapper().getNBTItem(item);
            for (IngredientType ingredient : MMOItems.plugin.getCrafting().getIngredients()) {
                if (!ingredient.check(nbt)) continue;
                this.addIngredient(nbt, ingredient);
                continue block0;
            }
        }
    }

    public void addIngredient(NBTItem item, IngredientType ingredient) {
        String key = ingredient.getId();
        List ingredients = this.ingredients.computeIfAbsent(key, ignored -> new ArrayList());
        ingredients.add(ingredient.readPlayerIngredient(item));
    }

    @Nullable
    public CheckedIngredient findMatching(@NotNull Ingredient ingredient) {
        ArrayList<PlayerIngredient> found = new ArrayList<PlayerIngredient>();
        if (!this.ingredients.containsKey(ingredient.getId())) {
            return new CheckedIngredient(ingredient, found);
        }
        for (PlayerIngredient checked : this.ingredients.get(ingredient.getId())) {
            if (!ingredient.matches(checked)) continue;
            found.add(checked);
        }
        return new CheckedIngredient(ingredient, found);
    }

    @Deprecated
    public boolean hasIngredient(Ingredient ingredient) {
        return this.findMatching(ingredient).isHad();
    }

    @Deprecated
    public static enum IngredientLookupMode {
        IGNORE_ITEM_LEVEL,
        BASIC;

    }
}

