/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.ingredient;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.crafting.ConfigMMOItem;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.MMOItemPlayerIngredient;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.stat.DisplayName;
import net.Indyuce.mmoitems.stat.data.MaterialData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class MMOItemIngredient
extends Ingredient<MMOItemPlayerIngredient> {
    private final MMOItemTemplate template;
    @NotNull
    private final QuickNumberRange level;
    private final String display;

    public MMOItemIngredient(MMOLineConfig config) {
        super("mmoitem", config);
        config.validate(new String[]{"type", "id"});
        Type type = MMOItems.plugin.getTypes().getOrThrow(config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_"));
        this.template = MMOItems.plugin.getTemplates().getTemplateOrThrow(type, config.getString("id"));
        QuickNumberRange qnr = QuickNumberRange.getFromString((String)config.getString("level", ".."));
        this.level = qnr != null ? qnr : new QuickNumberRange(null, null);
        this.display = config.contains("display") ? config.getString("display") : this.findName();
    }

    public MMOItemIngredient(ConfigMMOItem mmoitem) {
        super("mmoitem", mmoitem.getAmount());
        this.template = mmoitem.getTemplate();
        this.level = new QuickNumberRange(null, null);
        this.display = this.findName();
    }

    public MMOItemTemplate getTemplate() {
        return this.template;
    }

    @Override
    public String getKey() {
        return "mmoitem:" + this.template.getType().getId().toLowerCase() + (this.level.hasMax() || this.level.hasMax() ? "-" + this.level.toString() : "") + "_" + this.template.getId().toLowerCase();
    }

    @Override
    public String formatDisplay(String s) {
        return s.replace("#item#", this.display).replace("#level#", this.level.hasMax() || this.level.hasMax() ? "lvl." + this.level.toString() + " " : "").replace("#amount#", String.valueOf(this.getAmount()));
    }

    @Override
    public boolean matches(MMOItemPlayerIngredient playerIngredient) {
        if (!playerIngredient.getType().equals(this.template.getType().getId())) {
            return false;
        }
        if (!playerIngredient.getId().equals(this.template.getId())) {
            return false;
        }
        return SilentNumbers.floor((double)this.level.getAsDouble(0.0)) == 0 || this.level.inRange((double)playerIngredient.getUpgradeLevel());
    }

    @Override
    @NotNull
    public ItemStack generateItemStack(@NotNull RPGPlayer player, boolean forDisplay) {
        MMOItem mmo = this.template.newBuilder(player, forDisplay).build();
        ItemStack item = mmo.newBuilder().build(forDisplay);
        int lvl = SilentNumbers.floor((double)this.level.getAsDouble(0.0));
        if (lvl != 0 && item.getItemMeta() != null) {
            ItemMeta iMeta = item.getItemMeta();
            iMeta.setDisplayName(MythicLib.plugin.parseColors(this.findName()));
            item.setItemMeta(iMeta);
        }
        item.setAmount(this.getAmount());
        return item;
    }

    public String toString() {
        return this.getKey();
    }

    private String findName() {
        String name = this.template.getBaseItemData().containsKey(ItemStats.NAME) ? this.template.getBaseItemData().get(ItemStats.NAME).toString().replace("<tier-color>", "").replace("<tier-name>", "").replace("<tier-color-cleaned>", "") : (this.template.getBaseItemData().containsKey(ItemStats.MATERIAL) ? UtilityMethods.caseOnWords((String)((MaterialData)this.template.getBaseItemData().get(ItemStats.MATERIAL)).getMaterial().name().toLowerCase().replace("_", " ")) : "Unrecognized Item");
        if (SilentNumbers.floor((double)this.level.getAsDouble(0.0)) != 0) {
            return DisplayName.appendUpgradeLevel(name, SilentNumbers.floor((double)this.level.getAsDouble(0.0)));
        }
        return name;
    }
}

