/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.CraftingStation;
import net.Indyuce.mmoitems.api.crafting.recipe.CraftingRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.Recipe;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingStatus {
    private final Map<CraftingStation, CraftingQueue> queues = new HashMap<CraftingStation, CraftingQueue>();

    public void load(PlayerData data, ConfigurationSection config) {
        String name = data.isOnline() ? data.getPlayer().getName() : "Unknown Player";
        for (String stationId : config.getKeys(false)) {
            if (!MMOItems.plugin.getCrafting().hasStation(stationId)) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occurred while trying to load crafting station recipe data of '" + name + "': could not find crafting station with ID '" + stationId + "', make sure you backup that player data file before the user logs off.");
                continue;
            }
            CraftingStation station = MMOItems.plugin.getCrafting().getStation(stationId);
            CraftingQueue queue = new CraftingQueue(station);
            this.queues.put(station, queue);
            Optional legacyOpt = config.getConfigurationSection(stationId).getKeys(false).stream().findFirst();
            boolean legacyLoading = legacyOpt.isPresent() && config.contains(stationId + "." + (String)legacyOpt.get() + ".delay");
            for (String recipeConfigId : config.getConfigurationSection(stationId).getKeys(false)) {
                String recipeId = config.getString(stationId + "." + recipeConfigId + ".recipe");
                if (recipeId == null || !station.hasRecipe(recipeId)) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occurred while trying to load crafting station recipe data of '" + name + "': could not find recipe with ID '" + recipeId + "', make sure you backup that player data file before the user logs off.");
                    continue;
                }
                Recipe recipe = station.getRecipe(recipeId);
                if (!(recipe instanceof CraftingRecipe)) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occurred while trying to load crafting station recipe data of '" + name + "': recipe '" + recipe.getId() + "' is not a CRAFTING recipe.");
                    continue;
                }
                if (legacyLoading) {
                    long started = config.getLong(stationId + "." + recipeConfigId + ".started");
                    long delay = config.getLong(stationId + "." + recipeConfigId + ".delay");
                    queue.add((CraftingRecipe)recipe, started, started + delay);
                    continue;
                }
                queue.add((CraftingRecipe)recipe, config.getLong(stationId + "." + recipeConfigId + ".start"), config.getLong(stationId + "." + recipeConfigId + ".completion"));
            }
        }
    }

    public void save(ConfigurationSection config) {
        this.queues.forEach((station, queue) -> {
            for (CraftingQueue.QueueItem craft : queue.getCrafts()) {
                config.set(station.getId() + ".recipe-" + craft.getUniqueId().toString() + ".recipe", (Object)craft.getRecipe().getId());
                config.set(station.getId() + ".recipe-" + craft.getUniqueId().toString() + ".start", (Object)craft.start);
                config.set(station.getId() + ".recipe-" + craft.getUniqueId().toString() + ".completion", (Object)craft.completion);
            }
        });
    }

    public CraftingQueue getQueue(@NotNull CraftingStation station) {
        return this.queues.computeIfAbsent(station, CraftingQueue::new);
    }

    public static class CraftingQueue {
        private final String station;
        private final List<QueueItem> crafts = new ArrayList<QueueItem>();

        public CraftingQueue(CraftingStation station) {
            this.station = station.getId();
        }

        public List<QueueItem> getCrafts() {
            return this.crafts;
        }

        public boolean isFull(CraftingStation station) {
            return this.crafts.size() >= station.getMaxQueueSize();
        }

        public void remove(QueueItem item) {
            int index = this.crafts.indexOf(item);
            Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Could not find item in queue");
            this.crafts.remove(index);
            long gain = Math.min(item.getLeft(), (long)(1000.0 * item.getRecipe().getCraftingTime()));
            for (int j = index; j < this.crafts.size(); ++j) {
                this.crafts.get(j).removeDelay(gain);
            }
        }

        @Nullable
        public QueueItem getCraft(UUID uuid) {
            for (QueueItem craft : this.crafts) {
                if (!craft.getUniqueId().equals(uuid)) continue;
                return craft;
            }
            return null;
        }

        public void add(CraftingRecipe recipe) {
            long completion = (long)recipe.getCraftingTime() * 1000L + (this.crafts.isEmpty() ? System.currentTimeMillis() : this.crafts.get(this.crafts.size() - 1).completion);
            this.add(recipe, System.currentTimeMillis(), completion);
        }

        private void add(CraftingRecipe recipe, long start, long completion) {
            this.crafts.add(new QueueItem(recipe, start, completion));
        }

        public CraftingStation getStation() {
            return MMOItems.plugin.getCrafting().getStation(this.station);
        }

        public class QueueItem {
            private final String recipe;
            private final UUID uuid = UUID.randomUUID();
            private final long start;
            private long completion;

            public QueueItem(CraftingRecipe recipe, long start, long completion) {
                this.recipe = recipe.getId();
                this.start = start;
                this.completion = completion;
            }

            public UUID getUniqueId() {
                return this.uuid;
            }

            public CraftingRecipe getRecipe() {
                return (CraftingRecipe)CraftingQueue.this.getStation().getRecipe(this.recipe);
            }

            public boolean isReady() {
                return this.getLeft() == 0L;
            }

            public void removeDelay(long amount) {
                this.completion -= amount;
            }

            public long getElapsed() {
                return Math.max((long)this.getRecipe().getCraftingTime() * 1000L, System.currentTimeMillis() - this.start);
            }

            public long getLeft() {
                return Math.max(0L, this.completion - System.currentTimeMillis());
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                QueueItem that = (QueueItem)o;
                return Objects.equals(this.uuid, that.uuid);
            }

            public int hashCode() {
                return Objects.hash(this.uuid);
            }
        }
    }
}

