/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.util.PostLoadAction;
import io.lumine.mythic.lib.util.PreloadedObject;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.Layout;
import net.Indyuce.mmoitems.api.crafting.StationItemOptions;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.IngredientInventory;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.CraftingRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.Recipe;
import net.Indyuce.mmoitems.api.crafting.recipe.UpgradingRecipe;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingStation
implements PreloadedObject {
    private final String id;
    private final String name;
    private final Layout layout;
    private final Sound sound;
    private final StationItemOptions itemOptions;
    private final int maxQueueSize;
    private final Map<String, Recipe> recipes = new LinkedHashMap<String, Recipe>();
    private CraftingStation parent;
    private final PostLoadAction postLoadAction = new PostLoadAction(config -> {
        if (!config.contains("parent")) {
            return;
        }
        String id = config.getString("parent").toLowerCase().replace(" ", "-").replace("_", "-");
        Validate.isTrue((!id.equals(this.id) ? 1 : 0) != 0, (String)"Station cannot use itself as parent");
        Validate.isTrue((boolean)MMOItems.plugin.getCrafting().hasStation(id), (String)("Could not find parent station with ID '" + id + "'"));
        this.parent = MMOItems.plugin.getCrafting().getStation(id);
    });

    public CraftingStation(String id, FileConfiguration config2) {
        this.postLoadAction.cacheConfig((ConfigurationSection)config2);
        this.id = id.toLowerCase().replace("_", "-").replace(" ", "-");
        this.name = config2.getString("name", "A Station With No Name");
        this.layout = MMOItems.plugin.getLayouts().getLayout(config2.getString("layout", "default"));
        this.sound = Sounds.fromName((String[])new String[]{UtilityMethods.enumName((String)config2.getString("sound", "ENTITY_EXPERIENCE_ORB_PICKUP"))});
        for (String key : config2.getConfigurationSection("recipes").getKeys(false)) {
            try {
                this.registerRecipe(this.loadRecipe(config2.getConfigurationSection("recipes." + key)));
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "An issue occurred registering recipe '" + key + "' from crafting station '" + id + "': " + exception.getMessage());
            }
        }
        this.itemOptions = new StationItemOptions(config2.getConfigurationSection("items"));
        this.maxQueueSize = Math.max(1, Math.min(config2.getInt("max-queue-size"), 64));
    }

    public CraftingStation(String id, String name, Layout layout, Sound sound, StationItemOptions itemOptions, int maxQueueSize, CraftingStation parent) {
        Validate.notNull((Object)id, (String)"Crafting station ID must not be null");
        Validate.notNull((Object)name, (String)"Crafting station name must not be null");
        Validate.notNull((Object)sound, (String)"Crafting station sound must not be null");
        this.id = id.toLowerCase().replace("_", "-").replace(" ", "-");
        this.name = name;
        this.layout = layout;
        this.sound = sound;
        this.itemOptions = itemOptions;
        this.maxQueueSize = maxQueueSize;
        this.parent = parent;
    }

    @NotNull
    public PostLoadAction getPostLoadAction() {
        return this.postLoadAction;
    }

    public String getId() {
        return this.id;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Sound getSound() {
        return this.sound;
    }

    @Nullable
    public CraftingStation getParent() {
        return this.parent;
    }

    public Collection<Recipe> getRecipes() {
        if (this.parent == null) {
            return this.recipes.values();
        }
        ArrayList<Recipe> collected = new ArrayList<Recipe>(this.recipes.values());
        CraftingStation next = this.parent;
        while (next != null) {
            collected.addAll(next.recipes.values());
            next = next.parent;
        }
        return collected;
    }

    public boolean hasRecipe(String id) {
        return this.recipes.containsKey(id) || this.parent != null && this.parent.hasRecipe(id);
    }

    public Recipe getRecipe(String id) {
        Recipe found = this.recipes.get(id);
        return found == null && this.parent != null ? this.parent.getRecipe(id) : found;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public List<CheckedRecipe> getAvailableRecipes(PlayerData data, IngredientInventory inv) {
        ArrayList<CheckedRecipe> infos = new ArrayList<CheckedRecipe>();
        for (Recipe recipe : this.getRecipes()) {
            CheckedRecipe info = recipe.evaluateRecipe(data, inv);
            if (!info.areConditionsMet() && info.getRecipe().hasOption(Recipe.RecipeOption.HIDE_WHEN_LOCKED) || !info.allIngredientsHad() && info.getRecipe().hasOption(Recipe.RecipeOption.HIDE_WHEN_NO_INGREDIENTS)) continue;
            infos.add(info);
        }
        return infos;
    }

    public StationItemOptions getItemOptions() {
        return this.itemOptions;
    }

    public void registerRecipe(Recipe recipe) {
        this.recipes.put(recipe.getId(), recipe);
    }

    public int getMaxPage() {
        int recipes = this.getRecipes().size();
        return Math.max(1, (int)Math.ceil((double)recipes / (double)this.getLayout().getRecipeSlots().size()));
    }

    private Recipe loadRecipe(ConfigurationSection config) throws IllegalArgumentException {
        return config.contains("output") ? new CraftingRecipe(config) : new UpgradingRecipe(config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftingStation that = (CraftingStation)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

