/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting;

import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConfigMMOItem {
    private final MMOItemTemplate template;
    private final int amount;
    private ItemStack preview;

    public ConfigMMOItem(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Could not read MMOItem config");
        Validate.isTrue((config.contains("type") && config.contains("id") ? 1 : 0) != 0, (String)"Config must contain type and ID");
        Type type = MMOItems.plugin.getTypes().getOrThrow(config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_"));
        this.template = MMOItems.plugin.getTemplates().getTemplateOrThrow(type, config.getString("id"));
        this.amount = Math.max(1, config.getInt("amount"));
    }

    public ConfigMMOItem(MMOItemTemplate template, int amount) {
        Validate.notNull((Object)template, (String)"Could not register recipe output");
        this.template = template;
        this.amount = Math.max(1, amount);
    }

    @NotNull
    public ItemStack generate(@NotNull RPGPlayer player) {
        ItemStack item = this.template.newBuilder(player).build().newBuilder().build();
        item.setAmount(this.amount);
        return item;
    }

    public MMOItemTemplate getTemplate() {
        return this.template;
    }

    public ItemStack getPreview() {
        ItemStack itemStack;
        if (this.preview == null) {
            this.preview = new MMOItemBuilder(this.template, 0, null, true).build().newBuilder().build(true);
            itemStack = this.preview.clone();
        } else {
            itemStack = this.preview.clone();
        }
        return itemStack;
    }

    public int getAmount() {
        return this.amount;
    }
}

