/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api;

import java.util.ArrayList;
import net.Indyuce.mmoitems.api.util.MMOItemReforger;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReforgeOptions {
    public static boolean dropRestoredGems;
    private final boolean keepName;
    private final boolean keepLore;
    private final boolean keepEnchantments;
    private final boolean keepSkins;
    private final boolean keepUpgrades;
    private final boolean keepGemStones;
    private final boolean keepSoulBind;
    private final boolean keepExternalSH;
    private final boolean keepModifications;
    @Nullable
    private final Boolean keepTier;
    private final boolean reRoll;
    private final boolean keepAdvancedEnchantments;
    @NotNull
    String keepCase = ChatColor.GRAY.toString();
    @NotNull
    ArrayList<String> blacklistedItems = new ArrayList();

    public void setKeepCase(@NotNull String kc) {
        this.keepCase = kc;
    }

    @NotNull
    public String getKeepCase() {
        return this.keepCase;
    }

    public boolean isBlacklisted(@NotNull String mmoitemID) {
        return this.blacklistedItems.contains(mmoitemID);
    }

    public void addToBlacklist(@NotNull String mmoitemID) {
        this.blacklistedItems.add(mmoitemID);
    }

    public void clearBlacklist() {
        this.blacklistedItems.clear();
    }

    public ReforgeOptions(ConfigurationSection config) {
        this.keepName = config.getBoolean("display-name");
        this.keepLore = config.getBoolean("lore");
        this.keepEnchantments = config.getBoolean("enchantments");
        this.keepUpgrades = config.getBoolean("upgrades");
        this.keepGemStones = config.getBoolean("gemstones", false) || config.getBoolean("gems", false);
        this.keepSkins = config.getBoolean("skins", false);
        this.keepSoulBind = config.getBoolean("soulbound");
        this.keepCase = config.getString("kept-lore-prefix", ChatColor.GRAY.toString());
        this.keepExternalSH = config.getBoolean("external-sh", true);
        this.keepModifications = config.getBoolean("modifications");
        this.reRoll = config.getBoolean("reroll");
        this.keepAdvancedEnchantments = config.getBoolean("advanced-enchantments");
        this.keepTier = config.contains("tier") ? Boolean.valueOf(config.getBoolean("tier", true)) : null;
    }

    public ReforgeOptions() {
        this.keepName = false;
        this.keepLore = false;
        this.keepEnchantments = true;
        this.keepUpgrades = true;
        this.keepGemStones = true;
        this.keepSoulBind = true;
        this.keepExternalSH = true;
        this.reRoll = false;
        this.keepModifications = true;
        this.keepAdvancedEnchantments = true;
        this.keepSkins = true;
        this.keepTier = true;
    }

    boolean arr(@NotNull boolean[] booleans, int idx) {
        return booleans.length > idx && booleans[idx];
    }

    public boolean shouldReRoll() {
        return this.reRoll;
    }

    public boolean shouldKeepName() {
        return this.keepName;
    }

    public boolean shouldKeepMods() {
        return this.keepModifications;
    }

    public boolean shouldKeepLore() {
        return this.keepLore;
    }

    public boolean shouldKeepSkins() {
        return this.keepSkins;
    }

    public boolean shouldKeepTier() {
        return this.keepTier == null ? MMOItemReforger.keepTiersWhenReroll : this.keepTier;
    }

    public boolean shouldKeepEnchantments() {
        return this.keepEnchantments;
    }

    public boolean shouldKeepAdvancedEnchants() {
        return this.keepAdvancedEnchantments;
    }

    public boolean shouldKeepExternalSH() {
        return this.keepExternalSH;
    }

    public boolean shouldKeepUpgrades() {
        return this.keepUpgrades;
    }

    public boolean shouldKeepGemStones() {
        return this.keepGemStones;
    }

    public boolean shouldKeepSoulBind() {
        return this.keepSoulBind;
    }
}

