/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.skill.result.SkillResult;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.Map;
import java.util.Objects;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.skill.RegisteredSkill;
import net.Indyuce.mmoitems.stat.data.AbilityData;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItemsAPI {
    private final JavaPlugin plugin;

    public MMOItemsAPI(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerSkill(RegisteredSkill skill) {
        MMOItems.plugin.getSkills().registerSkill(skill);
    }

    public RegisteredSkill getSkillById(String id) {
        return Objects.requireNonNull(MMOItems.plugin.getSkills().getSkill(id), "Could not find skill with ID '" + id + "'");
    }

    public PlayerData getPlayerData(Player player) {
        return PlayerData.get((OfflinePlayer)player);
    }

    public RPGPlayer getRPGInfo(Player player) {
        return PlayerData.get((OfflinePlayer)player).getRPG();
    }

    public SkillResult castSkill(Player player, RegisteredSkill skill, @NotNull Map<String, Double> modifiers, @Nullable LivingEntity target, @Nullable AttackMetadata attackMeta) {
        AbilityData castable = new AbilityData(skill, TriggerType.CAST);
        modifiers.forEach((mod, value) -> castable.setModifier((String)mod, (double)value));
        PlayerMetadata caster = MMOPlayerData.get((OfflinePlayer)player).getStatMap().cache(EquipmentSlot.MAIN_HAND);
        return castable.cast(new TriggerMetadata(caster, (Entity)target, attackMeta));
    }
}

