/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.stat.data.AbilityData;
import net.Indyuce.mmoitems.stat.data.ParticleData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ItemSet {
    private final Map<Integer, SetBonuses> bonuses = new HashMap<Integer, SetBonuses>();
    private final List<String> loreTag;
    private final String name;
    private final String id;
    private static final int itemLimit = 10;

    public ItemSet(ConfigurationSection config) {
        this.id = config.getName().toUpperCase().replace("-", "_");
        this.loreTag = config.getStringList("lore-tag");
        this.name = config.getString("name");
        Validate.isTrue((boolean)config.isConfigurationSection("bonuses"), (String)"Could not find item set bonuses");
        for (int j = 2; j <= 10; ++j) {
            if (!config.getConfigurationSection("bonuses").contains(String.valueOf(j))) continue;
            String bonusesKey = String.format("bonuses.%d", j);
            SetBonuses bonuses = new SetBonuses();
            ConfigurationSection bonusesSection = config.getConfigurationSection(bonusesKey);
            Validate.notNull((Object)bonusesSection, (String)String.format("Item set '%s' is not a valid configuration section.", this.id));
            for (String perm : bonusesSection.getStringList("granted-permissions")) {
                bonuses.addPermission(perm);
            }
            for (String key : bonusesSection.getKeys(false)) {
                if (key.equals("granted-permissions")) continue;
                try {
                    ConfigurationSection section;
                    String format = key.toUpperCase().replace("-", "_").replace(" ", "_");
                    if (key.startsWith("ability-")) {
                        section = config.getConfigurationSection(String.format("%s.%s", bonusesKey, key));
                        Validate.notNull((Object)section, (String)String.format("Ability '%s' is not a valid configuration section.", key));
                        bonuses.addAbility(new AbilityData(section));
                        continue;
                    }
                    if (key.startsWith("potion-")) {
                        PotionEffectType potionEffectType = PotionEffectType.getByName((String)format.substring("potion-".length()));
                        Validate.notNull((Object)potionEffectType, (String)String.format("Could not load potion effect type from '%s'", format));
                        bonuses.addPotionEffect(new PotionEffect(potionEffectType, MMOUtils.getEffectDuration(potionEffectType), config.getInt(String.format("%s.%s", bonusesKey, key)) - 1, true, false));
                        continue;
                    }
                    if (key.startsWith("particle-")) {
                        section = config.getConfigurationSection(String.format("bonuses.%d.%s", j, key));
                        Validate.notNull((Object)section, (String)String.format("Particle effect '%s' is not a valid configuration section.", key));
                        bonuses.addParticle(new ParticleData(section));
                        continue;
                    }
                    ItemStat<?, ?> stat = MMOItems.plugin.getStats().get(format);
                    Validate.notNull(stat, (String)String.format("Could not find stat called '%s'", format));
                    bonuses.addStat(stat, config.getDouble(String.format("bonuses.%d.%s", j, key)));
                }
                catch (IllegalArgumentException exception) {
                    throw new IllegalArgumentException(String.format("Could not load set bonus '%s': %s", key, exception.getMessage()));
                }
            }
            this.bonuses.put(j, bonuses);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public SetBonuses getBonuses(int items) {
        SetBonuses bonuses = new SetBonuses();
        for (int j = 2; j <= Math.min(items, 10); ++j) {
            SetBonuses extra = this.bonuses.get(j);
            if (extra == null) continue;
            bonuses.merge(extra);
        }
        return bonuses;
    }

    public List<String> getLoreTag() {
        return this.loreTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemSet itemSet = (ItemSet)o;
        return this.id.equals(itemSet.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static class SetBonuses {
        private final Map<ItemStat<?, ?>, Double> stats = new HashMap();
        private final Map<PotionEffectType, PotionEffect> permEffects = new HashMap<PotionEffectType, PotionEffect>();
        private final List<AbilityData> abilities = new ArrayList<AbilityData>();
        private final List<ParticleData> particles = new ArrayList<ParticleData>();
        private final ArrayList<String> permissions = new ArrayList();

        public void addStat(ItemStat<?, ?> stat, double value) {
            this.stats.put(stat, value);
        }

        public void addPotionEffect(PotionEffect effect) {
            this.permEffects.put(effect.getType(), effect);
        }

        public void addAbility(AbilityData ability) {
            this.abilities.add(ability);
        }

        public void addParticle(ParticleData particle) {
            this.particles.add(particle);
        }

        public void addPermission(@NotNull String permission) {
            this.permissions.add(permission);
        }

        public boolean hasStat(ItemStat<?, ?> stat) {
            return this.stats.containsKey(stat);
        }

        public double getStat(ItemStat<?, ?> stat) {
            return this.stats.get(stat);
        }

        public Map<ItemStat<?, ?>, Double> getStats() {
            return this.stats;
        }

        public Collection<PotionEffect> getPotionEffects() {
            return this.permEffects.values();
        }

        public List<ParticleData> getParticles() {
            return this.particles;
        }

        public List<AbilityData> getAbilities() {
            return this.abilities;
        }

        @NotNull
        public ArrayList<String> getPermissions() {
            return this.permissions;
        }

        public void merge(SetBonuses bonuses) {
            bonuses.getStats().forEach((stat, value) -> this.stats.put((ItemStat<?, ?>)stat, (this.stats.containsKey(stat) ? this.stats.get(stat) : 0.0) + value));
            for (PotionEffect effect : bonuses.getPotionEffects()) {
                if (this.permEffects.containsKey(effect.getType()) && this.permEffects.get(effect.getType()).getAmplifier() >= effect.getAmplifier()) continue;
                this.permEffects.put(effect.getType(), effect);
            }
            this.abilities.addAll(bonuses.abilities);
            this.particles.addAll(bonuses.particles);
            this.permissions.addAll(bonuses.permissions);
        }
    }
}

