/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.recipes.listeners;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.mechanics.provided.misc.misc.MiscMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.misc.MiscMechanicFactory;
import io.th0rgal.oraxen.recipes.CustomRecipe;
import io.th0rgal.oraxen.recipes.listeners.SmithingRecipeEvents;
import io.th0rgal.oraxen.utils.InventoryUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class RecipesEventsManager
implements Listener {
    private static RecipesEventsManager instance;
    private Map<CustomRecipe, String> permissionsPerRecipe = new HashMap<CustomRecipe, String>();
    private Set<CustomRecipe> whitelistedCraftRecipes = new HashSet<CustomRecipe>();
    private ArrayList<CustomRecipe> whitelistedCraftRecipesOrdered = new ArrayList();

    public static RecipesEventsManager get() {
        if (instance == null) {
            instance = new RecipesEventsManager();
        }
        return instance;
    }

    public void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)instance, (Plugin)OraxenPlugin.get());
        if (VersionUtil.atOrAbove("1.20")) {
            Bukkit.getPluginManager().registerEvents((Listener)new SmithingRecipeEvents(), (Plugin)OraxenPlugin.get());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTrade(InventoryClickEvent event) {
        String secondIngredient;
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof MerchantInventory)) {
            return;
        }
        MerchantInventory merchantInventory = (MerchantInventory)inventory;
        if (event.getSlot() != 2 || merchantInventory.getSelectedRecipe() == null) {
            return;
        }
        String first = OraxenItems.getIdByItem(merchantInventory.getItem(0));
        String second = OraxenItems.getIdByItem(merchantInventory.getItem(1));
        ArrayList ingredients = new ArrayList(merchantInventory.getSelectedRecipe().getIngredients());
        String firstIngredient = ingredients.isEmpty() ? null : OraxenItems.getIdByItem((ItemStack)ingredients.get(0));
        String string = secondIngredient = ingredients.size() < 2 ? null : OraxenItems.getIdByItem((ItemStack)ingredients.get(1));
        if (!Objects.equals(first, firstIngredient) || !Objects.equals(second, secondIngredient)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onCrafted(PrepareItemCraftEvent event) {
        CustomRecipe customRecipe;
        block8: {
            block7: {
                ItemStack result;
                Recipe recipe = event.getRecipe();
                customRecipe = CustomRecipe.fromRecipe(recipe);
                Player player = InventoryUtils.playerFromView((InventoryEvent)event);
                if (!this.hasPermission((CommandSender)player, customRecipe)) {
                    event.getInventory().setResult(null);
                }
                if ((result = event.getInventory().getResult()) == null) {
                    return;
                }
                boolean containsOraxenItem = Arrays.stream(event.getInventory().getMatrix()).anyMatch(OraxenItems::exists);
                if (!containsOraxenItem || recipe == null) {
                    return;
                }
                if (Arrays.stream(event.getInventory().getMatrix()).anyMatch(item -> {
                    if (MiscMechanicFactory.get() == null) {
                        return false;
                    }
                    MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic((ItemStack)item);
                    return mechanic != null && !mechanic.isAllowedInVanillaRecipes();
                })) {
                    event.getInventory().setResult(null);
                    return;
                }
                if (customRecipe == null) break block7;
                if (!this.whitelistedCraftRecipes.stream().anyMatch(customRecipe::equals) && !customRecipe.isValidDyeRecipe()) break block8;
            }
            return;
        }
        event.getInventory().setResult(customRecipe.getResult());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!Settings.ADD_RECIPES_TO_BOOK.toBool().booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        player.discoverRecipes((Collection)this.getPermittedRecipes((CommandSender)player).stream().map(r -> NamespacedKey.fromString((String)r.getName(), (Plugin)OraxenPlugin.get())).collect(Collectors.toSet()));
    }

    public void resetRecipes() {
        this.permissionsPerRecipe = new HashMap<CustomRecipe, String>();
        this.whitelistedCraftRecipes = new HashSet<CustomRecipe>();
        this.whitelistedCraftRecipesOrdered = new ArrayList();
    }

    public void addPermissionRecipe(CustomRecipe recipe, String permission) {
        this.permissionsPerRecipe.put(recipe, permission);
    }

    public void whitelistRecipe(CustomRecipe recipe) {
        this.whitelistedCraftRecipes.add(recipe);
        this.whitelistedCraftRecipesOrdered.add(recipe);
    }

    public List<CustomRecipe> getPermittedRecipes(CommandSender sender) {
        return this.whitelistedCraftRecipesOrdered.stream().filter(customRecipe -> !this.permissionsPerRecipe.containsKey(customRecipe) || this.hasPermission(sender, (CustomRecipe)customRecipe)).toList();
    }

    public String[] getPermittedRecipesName(CommandSender sender) {
        return (String[])this.getPermittedRecipes(sender).stream().map(CustomRecipe::getName).toArray(String[]::new);
    }

    public boolean hasPermission(CommandSender sender, CustomRecipe recipe) {
        return !this.permissionsPerRecipe.containsKey(recipe) || sender.hasPermission(this.permissionsPerRecipe.get(recipe));
    }
}

